package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLiveMessageGroupUsers invokes the live.ListLiveMessageGroupUsers API synchronously
func (client *Client) ListLiveMessageGroupUsers(request *ListLiveMessageGroupUsersRequest) (response *ListLiveMessageGroupUsersResponse, err error) {
	response = CreateListLiveMessageGroupUsersResponse()
	err = client.DoAction(request, response)
	return
}

// ListLiveMessageGroupUsersWithChan invokes the live.ListLiveMessageGroupUsers API asynchronously
func (client *Client) ListLiveMessageGroupUsersWithChan(request *ListLiveMessageGroupUsersRequest) (<-chan *ListLiveMessageGroupUsersResponse, <-chan error) {
	responseChan := make(chan *ListLiveMessageGroupUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLiveMessageGroupUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLiveMessageGroupUsersWithCallback invokes the live.ListLiveMessageGroupUsers API asynchronously
func (client *Client) ListLiveMessageGroupUsersWithCallback(request *ListLiveMessageGroupUsersRequest, callback func(response *ListLiveMessageGroupUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLiveMessageGroupUsersResponse
		var err error
		defer close(result)
		response, err = client.ListLiveMessageGroupUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLiveMessageGroupUsersRequest is the request struct for api ListLiveMessageGroupUsers
type ListLiveMessageGroupUsersRequest struct {
	*requests.RpcRequest
	SortType      requests.Integer `position:"Query" name:"SortType"`
	NextPageToken requests.Integer `position:"Query" name:"NextPageToken"`
	GroupId       string           `position:"Query" name:"GroupId"`
	DataCenter    string           `position:"Query" name:"DataCenter"`
	AppId         string           `position:"Query" name:"AppId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// ListLiveMessageGroupUsersResponse is the response struct for api ListLiveMessageGroupUsers
type ListLiveMessageGroupUsersResponse struct {
	*responses.BaseResponse
	RequestId     string  `json:"RequestId" xml:"RequestId"`
	GroupId       string  `json:"GroupId" xml:"GroupId"`
	NextPageToken int64   `json:"NextPageToken" xml:"NextPageToken"`
	Hasmore       bool    `json:"Hasmore" xml:"Hasmore"`
	UserList      []Users `json:"UserList" xml:"UserList"`
}

// CreateListLiveMessageGroupUsersRequest creates a request to invoke ListLiveMessageGroupUsers API
func CreateListLiveMessageGroupUsersRequest() (request *ListLiveMessageGroupUsersRequest) {
	request = &ListLiveMessageGroupUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListLiveMessageGroupUsers", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLiveMessageGroupUsersResponse creates a response to parse from ListLiveMessageGroupUsers response
func CreateListLiveMessageGroupUsersResponse() (response *ListLiveMessageGroupUsersResponse) {
	response = &ListLiveMessageGroupUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
