package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyLiveMessageAppCallback invokes the live.ModifyLiveMessageAppCallback API synchronously
func (client *Client) ModifyLiveMessageAppCallback(request *ModifyLiveMessageAppCallbackRequest) (response *ModifyLiveMessageAppCallbackResponse, err error) {
	response = CreateModifyLiveMessageAppCallbackResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyLiveMessageAppCallbackWithChan invokes the live.ModifyLiveMessageAppCallback API asynchronously
func (client *Client) ModifyLiveMessageAppCallbackWithChan(request *ModifyLiveMessageAppCallbackRequest) (<-chan *ModifyLiveMessageAppCallbackResponse, <-chan error) {
	responseChan := make(chan *ModifyLiveMessageAppCallbackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyLiveMessageAppCallback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyLiveMessageAppCallbackWithCallback invokes the live.ModifyLiveMessageAppCallback API asynchronously
func (client *Client) ModifyLiveMessageAppCallbackWithCallback(request *ModifyLiveMessageAppCallbackRequest, callback func(response *ModifyLiveMessageAppCallbackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyLiveMessageAppCallbackResponse
		var err error
		defer close(result)
		response, err = client.ModifyLiveMessageAppCallback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyLiveMessageAppCallbackRequest is the request struct for api ModifyLiveMessageAppCallback
type ModifyLiveMessageAppCallbackRequest struct {
	*requests.RpcRequest
	DataCenter       string `position:"Query" name:"DataCenter"`
	AppId            string `position:"Query" name:"AppId"`
	EventCallbackUrl string `position:"Query" name:"EventCallbackUrl"`
}

// ModifyLiveMessageAppCallbackResponse is the response struct for api ModifyLiveMessageAppCallback
type ModifyLiveMessageAppCallbackResponse struct {
	*responses.BaseResponse
	RequestId                       string `json:"RequestId" xml:"RequestId"`
	AppId                           string `json:"AppId" xml:"AppId"`
	AppSign                         string `json:"AppSign" xml:"AppSign"`
	EventCallbackUrl                string `json:"EventCallbackUrl" xml:"EventCallbackUrl"`
	EventCallbackNeedAuthentication bool   `json:"EventCallbackNeedAuthentication" xml:"EventCallbackNeedAuthentication"`
}

// CreateModifyLiveMessageAppCallbackRequest creates a request to invoke ModifyLiveMessageAppCallback API
func CreateModifyLiveMessageAppCallbackRequest() (request *ModifyLiveMessageAppCallbackRequest) {
	request = &ModifyLiveMessageAppCallbackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ModifyLiveMessageAppCallback", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyLiveMessageAppCallbackResponse creates a response to parse from ModifyLiveMessageAppCallback response
func CreateModifyLiveMessageAppCallbackResponse() (response *ModifyLiveMessageAppCallbackResponse) {
	response = &ModifyLiveMessageAppCallbackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
