package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMultiPartyCollaborationChain invokes the ltl.ListMultiPartyCollaborationChain API synchronously
func (client *Client) ListMultiPartyCollaborationChain(request *ListMultiPartyCollaborationChainRequest) (response *ListMultiPartyCollaborationChainResponse, err error) {
	response = CreateListMultiPartyCollaborationChainResponse()
	err = client.DoAction(request, response)
	return
}

// ListMultiPartyCollaborationChainWithChan invokes the ltl.ListMultiPartyCollaborationChain API asynchronously
func (client *Client) ListMultiPartyCollaborationChainWithChan(request *ListMultiPartyCollaborationChainRequest) (<-chan *ListMultiPartyCollaborationChainResponse, <-chan error) {
	responseChan := make(chan *ListMultiPartyCollaborationChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMultiPartyCollaborationChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMultiPartyCollaborationChainWithCallback invokes the ltl.ListMultiPartyCollaborationChain API asynchronously
func (client *Client) ListMultiPartyCollaborationChainWithCallback(request *ListMultiPartyCollaborationChainRequest, callback func(response *ListMultiPartyCollaborationChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMultiPartyCollaborationChainResponse
		var err error
		defer close(result)
		response, err = client.ListMultiPartyCollaborationChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMultiPartyCollaborationChainRequest is the request struct for api ListMultiPartyCollaborationChain
type ListMultiPartyCollaborationChainRequest struct {
	*requests.RpcRequest
	Size       requests.Integer `position:"Query" name:"Size"`
	Num        requests.Integer `position:"Query" name:"Num"`
	Name       string           `position:"Query" name:"Name"`
	ApiVersion string           `position:"Query" name:"ApiVersion"`
}

// ListMultiPartyCollaborationChainResponse is the response struct for api ListMultiPartyCollaborationChain
type ListMultiPartyCollaborationChainResponse struct {
	*responses.BaseResponse
	Code      int                                    `json:"Code" xml:"Code"`
	Message   string                                 `json:"Message" xml:"Message"`
	RequestId string                                 `json:"RequestId" xml:"RequestId"`
	Success   bool                                   `json:"Success" xml:"Success"`
	Data      DataInListMultiPartyCollaborationChain `json:"Data" xml:"Data"`
}

// CreateListMultiPartyCollaborationChainRequest creates a request to invoke ListMultiPartyCollaborationChain API
func CreateListMultiPartyCollaborationChainRequest() (request *ListMultiPartyCollaborationChainRequest) {
	request = &ListMultiPartyCollaborationChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "ListMultiPartyCollaborationChain", "", "")
	request.Method = requests.POST
	return
}

// CreateListMultiPartyCollaborationChainResponse creates a response to parse from ListMultiPartyCollaborationChain response
func CreateListMultiPartyCollaborationChainResponse() (response *ListMultiPartyCollaborationChainResponse) {
	response = &ListMultiPartyCollaborationChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
