package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AgreeMemberAccess invokes the lto.AgreeMemberAccess API synchronously
func (client *Client) AgreeMemberAccess(request *AgreeMemberAccessRequest) (response *AgreeMemberAccessResponse, err error) {
	response = CreateAgreeMemberAccessResponse()
	err = client.DoAction(request, response)
	return
}

// AgreeMemberAccessWithChan invokes the lto.AgreeMemberAccess API asynchronously
func (client *Client) AgreeMemberAccessWithChan(request *AgreeMemberAccessRequest) (<-chan *AgreeMemberAccessResponse, <-chan error) {
	responseChan := make(chan *AgreeMemberAccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AgreeMemberAccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AgreeMemberAccessWithCallback invokes the lto.AgreeMemberAccess API asynchronously
func (client *Client) AgreeMemberAccessWithCallback(request *AgreeMemberAccessRequest, callback func(response *AgreeMemberAccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AgreeMemberAccessResponse
		var err error
		defer close(result)
		response, err = client.AgreeMemberAccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AgreeMemberAccessRequest is the request struct for api AgreeMemberAccess
type AgreeMemberAccessRequest struct {
	*requests.RpcRequest
	MemberAccountId string `position:"Query" name:"MemberAccountId"`
}

// AgreeMemberAccessResponse is the response struct for api AgreeMemberAccess
type AgreeMemberAccessResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAgreeMemberAccessRequest creates a request to invoke AgreeMemberAccess API
func CreateAgreeMemberAccessRequest() (request *AgreeMemberAccessRequest) {
	request = &AgreeMemberAccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "AgreeMemberAccess", "", "")
	request.Method = requests.POST
	return
}

// CreateAgreeMemberAccessResponse creates a response to parse from AgreeMemberAccess response
func CreateAgreeMemberAccessResponse() (response *AgreeMemberAccessResponse) {
	response = &AgreeMemberAccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
