package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccountRole invokes the lto.DescribeAccountRole API synchronously
func (client *Client) DescribeAccountRole(request *DescribeAccountRoleRequest) (response *DescribeAccountRoleResponse, err error) {
	response = CreateDescribeAccountRoleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccountRoleWithChan invokes the lto.DescribeAccountRole API asynchronously
func (client *Client) DescribeAccountRoleWithChan(request *DescribeAccountRoleRequest) (<-chan *DescribeAccountRoleResponse, <-chan error) {
	responseChan := make(chan *DescribeAccountRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccountRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccountRoleWithCallback invokes the lto.DescribeAccountRole API asynchronously
func (client *Client) DescribeAccountRoleWithCallback(request *DescribeAccountRoleRequest, callback func(response *DescribeAccountRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccountRoleResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccountRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccountRoleRequest is the request struct for api DescribeAccountRole
type DescribeAccountRoleRequest struct {
	*requests.RpcRequest
}

// DescribeAccountRoleResponse is the response struct for api DescribeAccountRole
type DescribeAccountRoleResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateDescribeAccountRoleRequest creates a request to invoke DescribeAccountRole API
func CreateDescribeAccountRoleRequest() (request *DescribeAccountRoleRequest) {
	request = &DescribeAccountRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeAccountRole", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAccountRoleResponse creates a response to parse from DescribeAccountRole response
func CreateDescribeAccountRoleResponse() (response *DescribeAccountRoleResponse) {
	response = &DescribeAccountRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
