package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBaaSFabricChannel invokes the lto.ListBaaSFabricChannel API synchronously
func (client *Client) ListBaaSFabricChannel(request *ListBaaSFabricChannelRequest) (response *ListBaaSFabricChannelResponse, err error) {
	response = CreateListBaaSFabricChannelResponse()
	err = client.DoAction(request, response)
	return
}

// ListBaaSFabricChannelWithChan invokes the lto.ListBaaSFabricChannel API asynchronously
func (client *Client) ListBaaSFabricChannelWithChan(request *ListBaaSFabricChannelRequest) (<-chan *ListBaaSFabricChannelResponse, <-chan error) {
	responseChan := make(chan *ListBaaSFabricChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBaaSFabricChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBaaSFabricChannelWithCallback invokes the lto.ListBaaSFabricChannel API asynchronously
func (client *Client) ListBaaSFabricChannelWithCallback(request *ListBaaSFabricChannelRequest, callback func(response *ListBaaSFabricChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBaaSFabricChannelResponse
		var err error
		defer close(result)
		response, err = client.ListBaaSFabricChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBaaSFabricChannelRequest is the request struct for api ListBaaSFabricChannel
type ListBaaSFabricChannelRequest struct {
	*requests.RpcRequest
	BaaSFabricConsortiumId string `position:"Query" name:"BaaSFabricConsortiumId"`
}

// ListBaaSFabricChannelResponse is the response struct for api ListBaaSFabricChannel
type ListBaaSFabricChannelResponse struct {
	*responses.BaseResponse
	Code           string                  `json:"Code" xml:"Code"`
	HttpStatusCode int                     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                  `json:"Message" xml:"Message"`
	RequestId      string                  `json:"RequestId" xml:"RequestId"`
	Success        bool                    `json:"Success" xml:"Success"`
	Data           []BaaSFabricChannelInfo `json:"Data" xml:"Data"`
}

// CreateListBaaSFabricChannelRequest creates a request to invoke ListBaaSFabricChannel API
func CreateListBaaSFabricChannelRequest() (request *ListBaaSFabricChannelRequest) {
	request = &ListBaaSFabricChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListBaaSFabricChannel", "", "")
	request.Method = requests.POST
	return
}

// CreateListBaaSFabricChannelResponse creates a response to parse from ListBaaSFabricChannel response
func CreateListBaaSFabricChannelResponse() (response *ListBaaSFabricChannelResponse) {
	response = &ListBaaSFabricChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
