package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SharePrivacyRule invokes the lto.SharePrivacyRule API synchronously
func (client *Client) SharePrivacyRule(request *SharePrivacyRuleRequest) (response *SharePrivacyRuleResponse, err error) {
	response = CreateSharePrivacyRuleResponse()
	err = client.DoAction(request, response)
	return
}

// SharePrivacyRuleWithChan invokes the lto.SharePrivacyRule API asynchronously
func (client *Client) SharePrivacyRuleWithChan(request *SharePrivacyRuleRequest) (<-chan *SharePrivacyRuleResponse, <-chan error) {
	responseChan := make(chan *SharePrivacyRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SharePrivacyRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SharePrivacyRuleWithCallback invokes the lto.SharePrivacyRule API asynchronously
func (client *Client) SharePrivacyRuleWithCallback(request *SharePrivacyRuleRequest, callback func(response *SharePrivacyRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SharePrivacyRuleResponse
		var err error
		defer close(result)
		response, err = client.SharePrivacyRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SharePrivacyRuleRequest is the request struct for api SharePrivacyRule
type SharePrivacyRuleRequest struct {
	*requests.RpcRequest
	MemberIdList  string `position:"Query" name:"MemberIdList"`
	PrivacyRuleId string `position:"Query" name:"PrivacyRuleId"`
}

// SharePrivacyRuleResponse is the response struct for api SharePrivacyRule
type SharePrivacyRuleResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateSharePrivacyRuleRequest creates a request to invoke SharePrivacyRule API
func CreateSharePrivacyRuleRequest() (request *SharePrivacyRuleRequest) {
	request = &SharePrivacyRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "SharePrivacyRule", "", "")
	request.Method = requests.POST
	return
}

// CreateSharePrivacyRuleResponse creates a response to parse from SharePrivacyRule response
func CreateSharePrivacyRuleResponse() (response *SharePrivacyRuleResponse) {
	response = &SharePrivacyRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
