package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RollbackCurrentProjectNode invokes the market.RollbackCurrentProjectNode API synchronously
func (client *Client) RollbackCurrentProjectNode(request *RollbackCurrentProjectNodeRequest) (response *RollbackCurrentProjectNodeResponse, err error) {
	response = CreateRollbackCurrentProjectNodeResponse()
	err = client.DoAction(request, response)
	return
}

// RollbackCurrentProjectNodeWithChan invokes the market.RollbackCurrentProjectNode API asynchronously
func (client *Client) RollbackCurrentProjectNodeWithChan(request *RollbackCurrentProjectNodeRequest) (<-chan *RollbackCurrentProjectNodeResponse, <-chan error) {
	responseChan := make(chan *RollbackCurrentProjectNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RollbackCurrentProjectNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RollbackCurrentProjectNodeWithCallback invokes the market.RollbackCurrentProjectNode API asynchronously
func (client *Client) RollbackCurrentProjectNodeWithCallback(request *RollbackCurrentProjectNodeRequest, callback func(response *RollbackCurrentProjectNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RollbackCurrentProjectNodeResponse
		var err error
		defer close(result)
		response, err = client.RollbackCurrentProjectNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RollbackCurrentProjectNodeRequest is the request struct for api RollbackCurrentProjectNode
type RollbackCurrentProjectNodeRequest struct {
	*requests.RpcRequest
	Remark     string           `position:"Query" name:"Remark"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	NodeId     requests.Integer `position:"Query" name:"NodeId"`
}

// RollbackCurrentProjectNodeResponse is the response struct for api RollbackCurrentProjectNode
type RollbackCurrentProjectNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateRollbackCurrentProjectNodeRequest creates a request to invoke RollbackCurrentProjectNode API
func CreateRollbackCurrentProjectNodeRequest() (request *RollbackCurrentProjectNodeRequest) {
	request = &RollbackCurrentProjectNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "RollbackCurrentProjectNode", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRollbackCurrentProjectNodeResponse creates a response to parse from RollbackCurrentProjectNode response
func CreateRollbackCurrentProjectNodeResponse() (response *RollbackCurrentProjectNodeResponse) {
	response = &RollbackCurrentProjectNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
