package mns_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTopicAttributes invokes the mns_open.GetTopicAttributes API synchronously
func (client *Client) GetTopicAttributes(request *GetTopicAttributesRequest) (response *GetTopicAttributesResponse, err error) {
	response = CreateGetTopicAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// GetTopicAttributesWithChan invokes the mns_open.GetTopicAttributes API asynchronously
func (client *Client) GetTopicAttributesWithChan(request *GetTopicAttributesRequest) (<-chan *GetTopicAttributesResponse, <-chan error) {
	responseChan := make(chan *GetTopicAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTopicAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTopicAttributesWithCallback invokes the mns_open.GetTopicAttributes API asynchronously
func (client *Client) GetTopicAttributesWithCallback(request *GetTopicAttributesRequest, callback func(response *GetTopicAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTopicAttributesResponse
		var err error
		defer close(result)
		response, err = client.GetTopicAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTopicAttributesRequest is the request struct for api GetTopicAttributes
type GetTopicAttributesRequest struct {
	*requests.RpcRequest
	TopicName string `position:"Query" name:"TopicName"`
}

// GetTopicAttributesResponse is the response struct for api GetTopicAttributes
type GetTopicAttributesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Status    string `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetTopicAttributesRequest creates a request to invoke GetTopicAttributes API
func CreateGetTopicAttributesRequest() (request *GetTopicAttributesRequest) {
	request = &GetTopicAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mns-open", "2022-01-19", "GetTopicAttributes", "mns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTopicAttributesResponse creates a response to parse from GetTopicAttributes response
func CreateGetTopicAttributesResponse() (response *GetTopicAttributesResponse) {
	response = &GetTopicAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
