package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcdpEventAttribute invokes the mpaas.CreateMcdpEventAttribute API synchronously
func (client *Client) CreateMcdpEventAttribute(request *CreateMcdpEventAttributeRequest) (response *CreateMcdpEventAttributeResponse, err error) {
	response = CreateCreateMcdpEventAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcdpEventAttributeWithChan invokes the mpaas.CreateMcdpEventAttribute API asynchronously
func (client *Client) CreateMcdpEventAttributeWithChan(request *CreateMcdpEventAttributeRequest) (<-chan *CreateMcdpEventAttributeResponse, <-chan error) {
	responseChan := make(chan *CreateMcdpEventAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcdpEventAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcdpEventAttributeWithCallback invokes the mpaas.CreateMcdpEventAttribute API asynchronously
func (client *Client) CreateMcdpEventAttributeWithCallback(request *CreateMcdpEventAttributeRequest, callback func(response *CreateMcdpEventAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcdpEventAttributeResponse
		var err error
		defer close(result)
		response, err = client.CreateMcdpEventAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcdpEventAttributeRequest is the request struct for api CreateMcdpEventAttribute
type CreateMcdpEventAttributeRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMcdpEventAttributeCreateJsonStr string `position:"Body" name:"MpaasMappcenterMcdpEventAttributeCreateJsonStr"`
	TenantId                                       string `position:"Body" name:"TenantId"`
	AppId                                          string `position:"Body" name:"AppId"`
	WorkspaceId                                    string `position:"Body" name:"WorkspaceId"`
}

// CreateMcdpEventAttributeResponse is the response struct for api CreateMcdpEventAttribute
type CreateMcdpEventAttributeResponse struct {
	*responses.BaseResponse
	ResultMessage string                                  `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                  `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                  `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMcdpEventAttribute `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMcdpEventAttributeRequest creates a request to invoke CreateMcdpEventAttribute API
func CreateCreateMcdpEventAttributeRequest() (request *CreateMcdpEventAttributeRequest) {
	request = &CreateMcdpEventAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcdpEventAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcdpEventAttributeResponse creates a response to parse from CreateMcdpEventAttribute response
func CreateCreateMcdpEventAttributeResponse() (response *CreateMcdpEventAttributeResponse) {
	response = &CreateMcdpEventAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
