package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMsacAppById invokes the mpaas.DeleteMsacAppById API synchronously
func (client *Client) DeleteMsacAppById(request *DeleteMsacAppByIdRequest) (response *DeleteMsacAppByIdResponse, err error) {
	response = CreateDeleteMsacAppByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMsacAppByIdWithChan invokes the mpaas.DeleteMsacAppById API asynchronously
func (client *Client) DeleteMsacAppByIdWithChan(request *DeleteMsacAppByIdRequest) (<-chan *DeleteMsacAppByIdResponse, <-chan error) {
	responseChan := make(chan *DeleteMsacAppByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMsacAppById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMsacAppByIdWithCallback invokes the mpaas.DeleteMsacAppById API asynchronously
func (client *Client) DeleteMsacAppByIdWithCallback(request *DeleteMsacAppByIdRequest, callback func(response *DeleteMsacAppByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMsacAppByIdResponse
		var err error
		defer close(result)
		response, err = client.DeleteMsacAppById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMsacAppByIdRequest is the request struct for api DeleteMsacAppById
type DeleteMsacAppByIdRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMsacDeleteAppJsonStr string `position:"Body" name:"MpaasMappcenterMsacDeleteAppJsonStr"`
	TenantId                            string `position:"Body" name:"TenantId"`
	AppId                               string `position:"Body" name:"AppId"`
	WorkspaceId                         string `position:"Body" name:"WorkspaceId"`
}

// DeleteMsacAppByIdResponse is the response struct for api DeleteMsacAppById
type DeleteMsacAppByIdResponse struct {
	*responses.BaseResponse
	ResultMessage string                           `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                           `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                           `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInDeleteMsacAppById `json:"ResultContent" xml:"ResultContent"`
}

// CreateDeleteMsacAppByIdRequest creates a request to invoke DeleteMsacAppById API
func CreateDeleteMsacAppByIdRequest() (request *DeleteMsacAppByIdRequest) {
	request = &DeleteMsacAppByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMsacAppById", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMsacAppByIdResponse creates a response to parse from DeleteMsacAppById response
func CreateDeleteMsacAppByIdResponse() (response *DeleteMsacAppByIdResponse) {
	response = &DeleteMsacAppByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
