package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetZookeeperDataImportUrl invokes the mse.GetZookeeperDataImportUrl API synchronously
func (client *Client) GetZookeeperDataImportUrl(request *GetZookeeperDataImportUrlRequest) (response *GetZookeeperDataImportUrlResponse, err error) {
	response = CreateGetZookeeperDataImportUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetZookeeperDataImportUrlWithChan invokes the mse.GetZookeeperDataImportUrl API asynchronously
func (client *Client) GetZookeeperDataImportUrlWithChan(request *GetZookeeperDataImportUrlRequest) (<-chan *GetZookeeperDataImportUrlResponse, <-chan error) {
	responseChan := make(chan *GetZookeeperDataImportUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetZookeeperDataImportUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetZookeeperDataImportUrlWithCallback invokes the mse.GetZookeeperDataImportUrl API asynchronously
func (client *Client) GetZookeeperDataImportUrlWithCallback(request *GetZookeeperDataImportUrlRequest, callback func(response *GetZookeeperDataImportUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetZookeeperDataImportUrlResponse
		var err error
		defer close(result)
		response, err = client.GetZookeeperDataImportUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetZookeeperDataImportUrlRequest is the request struct for api GetZookeeperDataImportUrl
type GetZookeeperDataImportUrlRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	ContentType    string `position:"Query" name:"ContentType"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// GetZookeeperDataImportUrlResponse is the response struct for api GetZookeeperDataImportUrl
type GetZookeeperDataImportUrlResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetZookeeperDataImportUrlRequest creates a request to invoke GetZookeeperDataImportUrl API
func CreateGetZookeeperDataImportUrlRequest() (request *GetZookeeperDataImportUrlRequest) {
	request = &GetZookeeperDataImportUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetZookeeperDataImportUrl", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetZookeeperDataImportUrlResponse creates a response to parse from GetZookeeperDataImportUrl response
func CreateGetZookeeperDataImportUrlResponse() (response *GetZookeeperDataImportUrlResponse) {
	response = &GetZookeeperDataImportUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
