package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayAuthConsumer invokes the mse.ListGatewayAuthConsumer API synchronously
func (client *Client) ListGatewayAuthConsumer(request *ListGatewayAuthConsumerRequest) (response *ListGatewayAuthConsumerResponse, err error) {
	response = CreateListGatewayAuthConsumerResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayAuthConsumerWithChan invokes the mse.ListGatewayAuthConsumer API asynchronously
func (client *Client) ListGatewayAuthConsumerWithChan(request *ListGatewayAuthConsumerRequest) (<-chan *ListGatewayAuthConsumerResponse, <-chan error) {
	responseChan := make(chan *ListGatewayAuthConsumerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayAuthConsumer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayAuthConsumerWithCallback invokes the mse.ListGatewayAuthConsumer API asynchronously
func (client *Client) ListGatewayAuthConsumerWithCallback(request *ListGatewayAuthConsumerRequest, callback func(response *ListGatewayAuthConsumerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayAuthConsumerResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayAuthConsumer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayAuthConsumerRequest is the request struct for api ListGatewayAuthConsumer
type ListGatewayAuthConsumerRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	Type            string           `position:"Query" name:"Type"`
	PageNum         string           `position:"Query" name:"PageNum"`
	PageSize        string           `position:"Query" name:"PageSize"`
	ConsumerStatus  requests.Boolean `position:"Query" name:"ConsumerStatus"`
	Name            string           `position:"Query" name:"Name"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// ListGatewayAuthConsumerResponse is the response struct for api ListGatewayAuthConsumer
type ListGatewayAuthConsumerResponse struct {
	*responses.BaseResponse
	RequestId      string                        `json:"RequestId" xml:"RequestId"`
	Success        bool                          `json:"Success" xml:"Success"`
	Code           int                           `json:"Code" xml:"Code"`
	ErrorCode      string                        `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int                           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                        `json:"Message" xml:"Message"`
	DynamicCode    string                        `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string                        `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           DataInListGatewayAuthConsumer `json:"Data" xml:"Data"`
}

// CreateListGatewayAuthConsumerRequest creates a request to invoke ListGatewayAuthConsumer API
func CreateListGatewayAuthConsumerRequest() (request *ListGatewayAuthConsumerRequest) {
	request = &ListGatewayAuthConsumerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListGatewayAuthConsumer", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayAuthConsumerResponse creates a response to parse from ListGatewayAuthConsumer response
func CreateListGatewayAuthConsumerResponse() (response *ListGatewayAuthConsumerResponse) {
	response = &ListGatewayAuthConsumerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
