package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitCopyrightJob invokes the mts.SubmitCopyrightJob API synchronously
func (client *Client) SubmitCopyrightJob(request *SubmitCopyrightJobRequest) (response *SubmitCopyrightJobResponse, err error) {
	response = CreateSubmitCopyrightJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitCopyrightJobWithChan invokes the mts.SubmitCopyrightJob API asynchronously
func (client *Client) SubmitCopyrightJobWithChan(request *SubmitCopyrightJobRequest) (<-chan *SubmitCopyrightJobResponse, <-chan error) {
	responseChan := make(chan *SubmitCopyrightJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitCopyrightJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitCopyrightJobWithCallback invokes the mts.SubmitCopyrightJob API asynchronously
func (client *Client) SubmitCopyrightJobWithCallback(request *SubmitCopyrightJobRequest, callback func(response *SubmitCopyrightJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitCopyrightJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitCopyrightJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitCopyrightJobRequest is the request struct for api SubmitCopyrightJob
type SubmitCopyrightJobRequest struct {
	*requests.RpcRequest
	VisibleMessage string           `position:"Query" name:"VisibleMessage"`
	Description    string           `position:"Query" name:"Description"`
	StartTime      string           `position:"Query" name:"StartTime"`
	Output         string           `position:"Query" name:"Output"`
	UserData       string           `position:"Query" name:"UserData"`
	Level          requests.Integer `position:"Query" name:"Level"`
	Message        string           `position:"Query" name:"Message"`
	Params         string           `position:"Query" name:"Params"`
	Url            string           `position:"Query" name:"Url"`
	Input          string           `position:"Query" name:"Input"`
	TotalTime      string           `position:"Query" name:"TotalTime"`
	CallBack       string           `position:"Query" name:"CallBack"`
}

// SubmitCopyrightJobResponse is the response struct for api SubmitCopyrightJob
type SubmitCopyrightJobResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Message    string `json:"Message" xml:"Message"`
	StatusCode int64  `json:"StatusCode" xml:"StatusCode"`
	Data       Data   `json:"Data" xml:"Data"`
}

// CreateSubmitCopyrightJobRequest creates a request to invoke SubmitCopyrightJob API
func CreateSubmitCopyrightJobRequest() (request *SubmitCopyrightJobRequest) {
	request = &SubmitCopyrightJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitCopyrightJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitCopyrightJobResponse creates a response to parse from SubmitCopyrightJob response
func CreateSubmitCopyrightJobResponse() (response *SubmitCopyrightJobResponse) {
	response = &SubmitCopyrightJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
