package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitTraceExtractJob invokes the mts.SubmitTraceExtractJob API synchronously
func (client *Client) SubmitTraceExtractJob(request *SubmitTraceExtractJobRequest) (response *SubmitTraceExtractJobResponse, err error) {
	response = CreateSubmitTraceExtractJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitTraceExtractJobWithChan invokes the mts.SubmitTraceExtractJob API asynchronously
func (client *Client) SubmitTraceExtractJobWithChan(request *SubmitTraceExtractJobRequest) (<-chan *SubmitTraceExtractJobResponse, <-chan error) {
	responseChan := make(chan *SubmitTraceExtractJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitTraceExtractJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitTraceExtractJobWithCallback invokes the mts.SubmitTraceExtractJob API asynchronously
func (client *Client) SubmitTraceExtractJobWithCallback(request *SubmitTraceExtractJobRequest, callback func(response *SubmitTraceExtractJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitTraceExtractJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitTraceExtractJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitTraceExtractJobRequest is the request struct for api SubmitTraceExtractJob
type SubmitTraceExtractJobRequest struct {
	*requests.RpcRequest
	Params   string `position:"Query" name:"Params"`
	Url      string `position:"Query" name:"Url"`
	Input    string `position:"Query" name:"Input"`
	UserData string `position:"Query" name:"UserData"`
	CallBack string `position:"Query" name:"CallBack"`
}

// SubmitTraceExtractJobResponse is the response struct for api SubmitTraceExtractJob
type SubmitTraceExtractJobResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Message    string `json:"Message" xml:"Message"`
	StatusCode int64  `json:"StatusCode" xml:"StatusCode"`
	Data       Data   `json:"Data" xml:"Data"`
}

// CreateSubmitTraceExtractJobRequest creates a request to invoke SubmitTraceExtractJob API
func CreateSubmitTraceExtractJobRequest() (request *SubmitTraceExtractJobRequest) {
	request = &SubmitTraceExtractJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitTraceExtractJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitTraceExtractJobResponse creates a response to parse from SubmitTraceExtractJob response
func CreateSubmitTraceExtractJobResponse() (response *SubmitTraceExtractJobResponse) {
	response = &SubmitTraceExtractJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
