package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDataFlowTask invokes the nas.CreateDataFlowTask API synchronously
func (client *Client) CreateDataFlowTask(request *CreateDataFlowTaskRequest) (response *CreateDataFlowTaskResponse, err error) {
	response = CreateCreateDataFlowTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDataFlowTaskWithChan invokes the nas.CreateDataFlowTask API asynchronously
func (client *Client) CreateDataFlowTaskWithChan(request *CreateDataFlowTaskRequest) (<-chan *CreateDataFlowTaskResponse, <-chan error) {
	responseChan := make(chan *CreateDataFlowTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDataFlowTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDataFlowTaskWithCallback invokes the nas.CreateDataFlowTask API asynchronously
func (client *Client) CreateDataFlowTaskWithCallback(request *CreateDataFlowTaskRequest, callback func(response *CreateDataFlowTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDataFlowTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateDataFlowTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDataFlowTaskRequest is the request struct for api CreateDataFlowTask
type CreateDataFlowTaskRequest struct {
	*requests.RpcRequest
	ClientToken  string           `position:"Query" name:"ClientToken"`
	Directory    string           `position:"Query" name:"Directory"`
	SrcTaskId    string           `position:"Query" name:"SrcTaskId"`
	DataType     string           `position:"Query" name:"DataType"`
	FileSystemId string           `position:"Query" name:"FileSystemId"`
	DryRun       requests.Boolean `position:"Query" name:"DryRun"`
	DataFlowId   string           `position:"Query" name:"DataFlowId"`
	EntryList    string           `position:"Query" name:"EntryList"`
	TaskAction   string           `position:"Query" name:"TaskAction"`
}

// CreateDataFlowTaskResponse is the response struct for api CreateDataFlowTask
type CreateDataFlowTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateCreateDataFlowTaskRequest creates a request to invoke CreateDataFlowTask API
func CreateCreateDataFlowTaskRequest() (request *CreateDataFlowTaskRequest) {
	request = &CreateDataFlowTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "CreateDataFlowTask", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDataFlowTaskResponse creates a response to parse from CreateDataFlowTask response
func CreateCreateDataFlowTaskResponse() (response *CreateDataFlowTaskResponse) {
	response = &CreateDataFlowTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
