package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableSmbAcl invokes the nas.EnableSmbAcl API synchronously
func (client *Client) EnableSmbAcl(request *EnableSmbAclRequest) (response *EnableSmbAclResponse, err error) {
	response = CreateEnableSmbAclResponse()
	err = client.DoAction(request, response)
	return
}

// EnableSmbAclWithChan invokes the nas.EnableSmbAcl API asynchronously
func (client *Client) EnableSmbAclWithChan(request *EnableSmbAclRequest) (<-chan *EnableSmbAclResponse, <-chan error) {
	responseChan := make(chan *EnableSmbAclResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableSmbAcl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableSmbAclWithCallback invokes the nas.EnableSmbAcl API asynchronously
func (client *Client) EnableSmbAclWithCallback(request *EnableSmbAclRequest, callback func(response *EnableSmbAclResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableSmbAclResponse
		var err error
		defer close(result)
		response, err = client.EnableSmbAcl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableSmbAclRequest is the request struct for api EnableSmbAcl
type EnableSmbAclRequest struct {
	*requests.RpcRequest
	Keytab       string `position:"Query" name:"Keytab"`
	KeytabMd5    string `position:"Query" name:"KeytabMd5"`
	FileSystemId string `position:"Query" name:"FileSystemId"`
}

// EnableSmbAclResponse is the response struct for api EnableSmbAcl
type EnableSmbAclResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableSmbAclRequest creates a request to invoke EnableSmbAcl API
func CreateEnableSmbAclRequest() (request *EnableSmbAclRequest) {
	request = &EnableSmbAclRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "EnableSmbAcl", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableSmbAclResponse creates a response to parse from EnableSmbAcl response
func CreateEnableSmbAclResponse() (response *EnableSmbAclResponse) {
	response = &EnableSmbAclResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
