package nlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSecurityPolicy invokes the nlb.DeleteSecurityPolicy API synchronously
func (client *Client) DeleteSecurityPolicy(request *DeleteSecurityPolicyRequest) (response *DeleteSecurityPolicyResponse, err error) {
	response = CreateDeleteSecurityPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSecurityPolicyWithChan invokes the nlb.DeleteSecurityPolicy API asynchronously
func (client *Client) DeleteSecurityPolicyWithChan(request *DeleteSecurityPolicyRequest) (<-chan *DeleteSecurityPolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteSecurityPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSecurityPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSecurityPolicyWithCallback invokes the nlb.DeleteSecurityPolicy API asynchronously
func (client *Client) DeleteSecurityPolicyWithCallback(request *DeleteSecurityPolicyRequest, callback func(response *DeleteSecurityPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSecurityPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteSecurityPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSecurityPolicyRequest is the request struct for api DeleteSecurityPolicy
type DeleteSecurityPolicyRequest struct {
	*requests.RpcRequest
	ClientToken      string           `position:"Body" name:"ClientToken"`
	DryRun           requests.Boolean `position:"Body" name:"DryRun"`
	SecurityPolicyId string           `position:"Body" name:"SecurityPolicyId"`
}

// DeleteSecurityPolicyResponse is the response struct for api DeleteSecurityPolicy
type DeleteSecurityPolicyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	JobId          string `json:"JobId" xml:"JobId"`
}

// CreateDeleteSecurityPolicyRequest creates a request to invoke DeleteSecurityPolicy API
func CreateDeleteSecurityPolicyRequest() (request *DeleteSecurityPolicyRequest) {
	request = &DeleteSecurityPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Nlb", "2022-04-30", "DeleteSecurityPolicy", "nlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSecurityPolicyResponse creates a response to parse from DeleteSecurityPolicy response
func CreateDeleteSecurityPolicyResponse() (response *DeleteSecurityPolicyResponse) {
	response = &DeleteSecurityPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
