package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTenantSecurityIpGroup invokes the oceanbasepro.CreateTenantSecurityIpGroup API synchronously
func (client *Client) CreateTenantSecurityIpGroup(request *CreateTenantSecurityIpGroupRequest) (response *CreateTenantSecurityIpGroupResponse, err error) {
	response = CreateCreateTenantSecurityIpGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTenantSecurityIpGroupWithChan invokes the oceanbasepro.CreateTenantSecurityIpGroup API asynchronously
func (client *Client) CreateTenantSecurityIpGroupWithChan(request *CreateTenantSecurityIpGroupRequest) (<-chan *CreateTenantSecurityIpGroupResponse, <-chan error) {
	responseChan := make(chan *CreateTenantSecurityIpGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTenantSecurityIpGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTenantSecurityIpGroupWithCallback invokes the oceanbasepro.CreateTenantSecurityIpGroup API asynchronously
func (client *Client) CreateTenantSecurityIpGroupWithCallback(request *CreateTenantSecurityIpGroupRequest, callback func(response *CreateTenantSecurityIpGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTenantSecurityIpGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateTenantSecurityIpGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTenantSecurityIpGroupRequest is the request struct for api CreateTenantSecurityIpGroup
type CreateTenantSecurityIpGroupRequest struct {
	*requests.RpcRequest
	SecurityIps         string `position:"Body" name:"SecurityIps"`
	SecurityIpGroupName string `position:"Body" name:"SecurityIpGroupName"`
	InstanceId          string `position:"Body" name:"InstanceId"`
	TenantId            string `position:"Body" name:"TenantId"`
}

// CreateTenantSecurityIpGroupResponse is the response struct for api CreateTenantSecurityIpGroup
type CreateTenantSecurityIpGroupResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	SecurityIpGroup SecurityIpGroup `json:"SecurityIpGroup" xml:"SecurityIpGroup"`
}

// CreateCreateTenantSecurityIpGroupRequest creates a request to invoke CreateTenantSecurityIpGroup API
func CreateCreateTenantSecurityIpGroupRequest() (request *CreateTenantSecurityIpGroupRequest) {
	request = &CreateTenantSecurityIpGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateTenantSecurityIpGroup", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTenantSecurityIpGroupResponse creates a response to parse from CreateTenantSecurityIpGroup response
func CreateCreateTenantSecurityIpGroupResponse() (response *CreateTenantSecurityIpGroupResponse) {
	response = &CreateTenantSecurityIpGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
