package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackupEncryptedString invokes the oceanbasepro.DescribeBackupEncryptedString API synchronously
func (client *Client) DescribeBackupEncryptedString(request *DescribeBackupEncryptedStringRequest) (response *DescribeBackupEncryptedStringResponse, err error) {
	response = CreateDescribeBackupEncryptedStringResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupEncryptedStringWithChan invokes the oceanbasepro.DescribeBackupEncryptedString API asynchronously
func (client *Client) DescribeBackupEncryptedStringWithChan(request *DescribeBackupEncryptedStringRequest) (<-chan *DescribeBackupEncryptedStringResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupEncryptedStringResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackupEncryptedString(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupEncryptedStringWithCallback invokes the oceanbasepro.DescribeBackupEncryptedString API asynchronously
func (client *Client) DescribeBackupEncryptedStringWithCallback(request *DescribeBackupEncryptedStringRequest, callback func(response *DescribeBackupEncryptedStringResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupEncryptedStringResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackupEncryptedString(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupEncryptedStringRequest is the request struct for api DescribeBackupEncryptedString
type DescribeBackupEncryptedStringRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
}

// DescribeBackupEncryptedStringResponse is the response struct for api DescribeBackupEncryptedString
type DescribeBackupEncryptedStringResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeBackupEncryptedStringRequest creates a request to invoke DescribeBackupEncryptedString API
func CreateDescribeBackupEncryptedStringRequest() (request *DescribeBackupEncryptedStringRequest) {
	request = &DescribeBackupEncryptedStringRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeBackupEncryptedString", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBackupEncryptedStringResponse creates a response to parse from DescribeBackupEncryptedString response
func CreateDescribeBackupEncryptedStringResponse() (response *DescribeBackupEncryptedStringResponse) {
	response = &DescribeBackupEncryptedStringResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
