package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceTenantModes invokes the oceanbasepro.DescribeInstanceTenantModes API synchronously
func (client *Client) DescribeInstanceTenantModes(request *DescribeInstanceTenantModesRequest) (response *DescribeInstanceTenantModesResponse, err error) {
	response = CreateDescribeInstanceTenantModesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceTenantModesWithChan invokes the oceanbasepro.DescribeInstanceTenantModes API asynchronously
func (client *Client) DescribeInstanceTenantModesWithChan(request *DescribeInstanceTenantModesRequest) (<-chan *DescribeInstanceTenantModesResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceTenantModesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceTenantModes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceTenantModesWithCallback invokes the oceanbasepro.DescribeInstanceTenantModes API asynchronously
func (client *Client) DescribeInstanceTenantModesWithCallback(request *DescribeInstanceTenantModesRequest, callback func(response *DescribeInstanceTenantModesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceTenantModesResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceTenantModes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceTenantModesRequest is the request struct for api DescribeInstanceTenantModes
type DescribeInstanceTenantModesRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
}

// DescribeInstanceTenantModesResponse is the response struct for api DescribeInstanceTenantModes
type DescribeInstanceTenantModesResponse struct {
	*responses.BaseResponse
	RequestId     string   `json:"RequestId" xml:"RequestId"`
	InstanceModes []string `json:"InstanceModes" xml:"InstanceModes"`
}

// CreateDescribeInstanceTenantModesRequest creates a request to invoke DescribeInstanceTenantModes API
func CreateDescribeInstanceTenantModesRequest() (request *DescribeInstanceTenantModesRequest) {
	request = &DescribeInstanceTenantModesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeInstanceTenantModes", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceTenantModesResponse creates a response to parse from DescribeInstanceTenantModes response
func CreateDescribeInstanceTenantModesResponse() (response *DescribeInstanceTenantModesResponse) {
	response = &DescribeInstanceTenantModesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
