package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTenantSecurityConfigs invokes the oceanbasepro.DescribeTenantSecurityConfigs API synchronously
func (client *Client) DescribeTenantSecurityConfigs(request *DescribeTenantSecurityConfigsRequest) (response *DescribeTenantSecurityConfigsResponse, err error) {
	response = CreateDescribeTenantSecurityConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTenantSecurityConfigsWithChan invokes the oceanbasepro.DescribeTenantSecurityConfigs API asynchronously
func (client *Client) DescribeTenantSecurityConfigsWithChan(request *DescribeTenantSecurityConfigsRequest) (<-chan *DescribeTenantSecurityConfigsResponse, <-chan error) {
	responseChan := make(chan *DescribeTenantSecurityConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTenantSecurityConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTenantSecurityConfigsWithCallback invokes the oceanbasepro.DescribeTenantSecurityConfigs API asynchronously
func (client *Client) DescribeTenantSecurityConfigsWithCallback(request *DescribeTenantSecurityConfigsRequest, callback func(response *DescribeTenantSecurityConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTenantSecurityConfigsResponse
		var err error
		defer close(result)
		response, err = client.DescribeTenantSecurityConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTenantSecurityConfigsRequest is the request struct for api DescribeTenantSecurityConfigs
type DescribeTenantSecurityConfigsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
	CheckId    string `position:"Body" name:"CheckId"`
}

// DescribeTenantSecurityConfigsResponse is the response struct for api DescribeTenantSecurityConfigs
type DescribeTenantSecurityConfigsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Configs   Configs `json:"Configs" xml:"Configs"`
}

// CreateDescribeTenantSecurityConfigsRequest creates a request to invoke DescribeTenantSecurityConfigs API
func CreateDescribeTenantSecurityConfigsRequest() (request *DescribeTenantSecurityConfigsRequest) {
	request = &DescribeTenantSecurityConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTenantSecurityConfigs", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTenantSecurityConfigsResponse creates a response to parse from DescribeTenantSecurityConfigs response
func CreateDescribeTenantSecurityConfigsResponse() (response *DescribeTenantSecurityConfigsResponse) {
	response = &DescribeTenantSecurityConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
