package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFunctionTask invokes the opensearch.CreateFunctionTask API synchronously
func (client *Client) CreateFunctionTask(request *CreateFunctionTaskRequest) (response *CreateFunctionTaskResponse, err error) {
	response = CreateCreateFunctionTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFunctionTaskWithChan invokes the opensearch.CreateFunctionTask API asynchronously
func (client *Client) CreateFunctionTaskWithChan(request *CreateFunctionTaskRequest) (<-chan *CreateFunctionTaskResponse, <-chan error) {
	responseChan := make(chan *CreateFunctionTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFunctionTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFunctionTaskWithCallback invokes the opensearch.CreateFunctionTask API asynchronously
func (client *Client) CreateFunctionTaskWithCallback(request *CreateFunctionTaskRequest, callback func(response *CreateFunctionTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFunctionTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateFunctionTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFunctionTaskRequest is the request struct for api CreateFunctionTask
type CreateFunctionTaskRequest struct {
	*requests.RoaRequest
	InstanceName     string `position:"Path" name:"instanceName"`
	FunctionName     string `position:"Path" name:"functionName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// CreateFunctionTaskResponse is the response struct for api CreateFunctionTask
type CreateFunctionTaskResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	HttpCode  int64  `json:"HttpCode" xml:"HttpCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Latency   int64  `json:"Latency" xml:"Latency"`
}

// CreateCreateFunctionTaskRequest creates a request to invoke CreateFunctionTask API
func CreateCreateFunctionTaskRequest() (request *CreateFunctionTaskRequest) {
	request = &CreateFunctionTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "CreateFunctionTask", "/v4/openapi/app-groups/[appGroupIdentity]/functions/[functionName]/instances/[instanceName]/tasks", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateFunctionTaskResponse creates a response to parse from CreateFunctionTask response
func CreateCreateFunctionTaskResponse() (response *CreateFunctionTaskResponse) {
	response = &CreateFunctionTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
