package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableSlowQuery invokes the opensearch.EnableSlowQuery API synchronously
func (client *Client) EnableSlowQuery(request *EnableSlowQueryRequest) (response *EnableSlowQueryResponse, err error) {
	response = CreateEnableSlowQueryResponse()
	err = client.DoAction(request, response)
	return
}

// EnableSlowQueryWithChan invokes the opensearch.EnableSlowQuery API asynchronously
func (client *Client) EnableSlowQueryWithChan(request *EnableSlowQueryRequest) (<-chan *EnableSlowQueryResponse, <-chan error) {
	responseChan := make(chan *EnableSlowQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableSlowQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableSlowQueryWithCallback invokes the opensearch.EnableSlowQuery API asynchronously
func (client *Client) EnableSlowQueryWithCallback(request *EnableSlowQueryRequest, callback func(response *EnableSlowQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableSlowQueryResponse
		var err error
		defer close(result)
		response, err = client.EnableSlowQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableSlowQueryRequest is the request struct for api EnableSlowQuery
type EnableSlowQueryRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// EnableSlowQueryResponse is the response struct for api EnableSlowQuery
type EnableSlowQueryResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"requestId" xml:"requestId"`
}

// CreateEnableSlowQueryRequest creates a request to invoke EnableSlowQuery API
func CreateEnableSlowQueryRequest() (request *EnableSlowQueryRequest) {
	request = &EnableSlowQueryRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "EnableSlowQuery", "/v4/openapi/app-groups/[appGroupIdentity]/optimizers/slow-query/actions/enable", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableSlowQueryResponse creates a response to parse from EnableSlowQuery response
func CreateEnableSlowQueryResponse() (response *EnableSlowQueryResponse) {
	response = &EnableSlowQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
