package osssddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSddpVersion invokes the osssddp.GetSddpVersion API synchronously
func (client *Client) GetSddpVersion(request *GetSddpVersionRequest) (response *GetSddpVersionResponse, err error) {
	response = CreateGetSddpVersionResponse()
	err = client.DoAction(request, response)
	return
}

// GetSddpVersionWithChan invokes the osssddp.GetSddpVersion API asynchronously
func (client *Client) GetSddpVersionWithChan(request *GetSddpVersionRequest) (<-chan *GetSddpVersionResponse, <-chan error) {
	responseChan := make(chan *GetSddpVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSddpVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSddpVersionWithCallback invokes the osssddp.GetSddpVersion API asynchronously
func (client *Client) GetSddpVersionWithCallback(request *GetSddpVersionRequest, callback func(response *GetSddpVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSddpVersionResponse
		var err error
		defer close(result)
		response, err = client.GetSddpVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSddpVersionRequest is the request struct for api GetSddpVersion
type GetSddpVersionRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
}

// GetSddpVersionResponse is the response struct for api GetSddpVersion
type GetSddpVersionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Content   int    `json:"Content" xml:"Content"`
}

// CreateGetSddpVersionRequest creates a request to invoke GetSddpVersion API
func CreateGetSddpVersionRequest() (request *GetSddpVersionRequest) {
	request = &GetSddpVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OssSddp", "2024-02-22", "GetSddpVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSddpVersionResponse creates a response to parse from GetSddpVersion response
func CreateGetSddpVersionResponse() (response *GetSddpVersionResponse) {
	response = &GetSddpVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
