package ots

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindInstance2Vpc invokes the ots.UnbindInstance2Vpc API synchronously
// api document: https://help.aliyun.com/api/ots/unbindinstance2vpc.html
func (client *Client) UnbindInstance2Vpc(request *UnbindInstance2VpcRequest) (response *UnbindInstance2VpcResponse, err error) {
	response = CreateUnbindInstance2VpcResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindInstance2VpcWithChan invokes the ots.UnbindInstance2Vpc API asynchronously
// api document: https://help.aliyun.com/api/ots/unbindinstance2vpc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindInstance2VpcWithChan(request *UnbindInstance2VpcRequest) (<-chan *UnbindInstance2VpcResponse, <-chan error) {
	responseChan := make(chan *UnbindInstance2VpcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindInstance2Vpc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindInstance2VpcWithCallback invokes the ots.UnbindInstance2Vpc API asynchronously
// api document: https://help.aliyun.com/api/ots/unbindinstance2vpc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindInstance2VpcWithCallback(request *UnbindInstance2VpcRequest, callback func(response *UnbindInstance2VpcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindInstance2VpcResponse
		var err error
		defer close(result)
		response, err = client.UnbindInstance2Vpc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindInstance2VpcRequest is the request struct for api UnbindInstance2Vpc
type UnbindInstance2VpcRequest struct {
	*requests.RpcRequest
	AccessKeyId     string           `position:"Query" name:"access_key_id"`
	InstanceVpcName string           `position:"Query" name:"InstanceVpcName"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceName    string           `position:"Query" name:"InstanceName"`
	RegionNo        string           `position:"Query" name:"RegionNo"`
}

// UnbindInstance2VpcResponse is the response struct for api UnbindInstance2Vpc
type UnbindInstance2VpcResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindInstance2VpcRequest creates a request to invoke UnbindInstance2Vpc API
func CreateUnbindInstance2VpcRequest() (request *UnbindInstance2VpcRequest) {
	request = &UnbindInstance2VpcRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ots", "2016-06-20", "UnbindInstance2Vpc", "ots", "openAPI")
	return
}

// CreateUnbindInstance2VpcResponse creates a response to parse from UnbindInstance2Vpc response
func CreateUnbindInstance2VpcResponse() (response *UnbindInstance2VpcResponse) {
	response = &UnbindInstance2VpcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
