package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobsByGroup invokes the outboundbot.ListJobsByGroup API synchronously
func (client *Client) ListJobsByGroup(request *ListJobsByGroupRequest) (response *ListJobsByGroupResponse, err error) {
	response = CreateListJobsByGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobsByGroupWithChan invokes the outboundbot.ListJobsByGroup API asynchronously
func (client *Client) ListJobsByGroupWithChan(request *ListJobsByGroupRequest) (<-chan *ListJobsByGroupResponse, <-chan error) {
	responseChan := make(chan *ListJobsByGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobsByGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobsByGroupWithCallback invokes the outboundbot.ListJobsByGroup API asynchronously
func (client *Client) ListJobsByGroupWithCallback(request *ListJobsByGroupRequest, callback func(response *ListJobsByGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobsByGroupResponse
		var err error
		defer close(result)
		response, err = client.ListJobsByGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobsByGroupRequest is the request struct for api ListJobsByGroup
type ListJobsByGroupRequest struct {
	*requests.RpcRequest
	JobStatus        string           `position:"Query" name:"JobStatus"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
	JobFailureReason string           `position:"Query" name:"JobFailureReason"`
	JobGroupId       string           `position:"Query" name:"JobGroupId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
}

// ListJobsByGroupResponse is the response struct for api ListJobsByGroup
type ListJobsByGroupResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Jobs           Jobs   `json:"Jobs" xml:"Jobs"`
}

// CreateListJobsByGroupRequest creates a request to invoke ListJobsByGroup API
func CreateListJobsByGroupRequest() (request *ListJobsByGroupRequest) {
	request = &ListJobsByGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ListJobsByGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateListJobsByGroupResponse creates a response to parse from ListJobsByGroup response
func CreateListJobsByGroupResponse() (response *ListJobsByGroupResponse) {
	response = &ListJobsByGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
