package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDatasource invokes the paifeaturestore.GetDatasource API synchronously
func (client *Client) GetDatasource(request *GetDatasourceRequest) (response *GetDatasourceResponse, err error) {
	response = CreateGetDatasourceResponse()
	err = client.DoAction(request, response)
	return
}

// GetDatasourceWithChan invokes the paifeaturestore.GetDatasource API asynchronously
func (client *Client) GetDatasourceWithChan(request *GetDatasourceRequest) (<-chan *GetDatasourceResponse, <-chan error) {
	responseChan := make(chan *GetDatasourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDatasource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDatasourceWithCallback invokes the paifeaturestore.GetDatasource API asynchronously
func (client *Client) GetDatasourceWithCallback(request *GetDatasourceRequest, callback func(response *GetDatasourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDatasourceResponse
		var err error
		defer close(result)
		response, err = client.GetDatasource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDatasourceRequest is the request struct for api GetDatasource
type GetDatasourceRequest struct {
	*requests.RoaRequest
	InstanceId   string `position:"Path" name:"InstanceId"`
	DatasourceId string `position:"Path" name:"DatasourceId"`
}

// GetDatasourceResponse is the response struct for api GetDatasource
type GetDatasourceResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	DatasourceId    string `json:"DatasourceId" xml:"DatasourceId"`
	Name            string `json:"Name" xml:"Name"`
	Type            string `json:"Type" xml:"Type"`
	Uri             string `json:"Uri" xml:"Uri"`
	Config          string `json:"Config" xml:"Config"`
	WorkspaceId     string `json:"WorkspaceId" xml:"WorkspaceId"`
	GmtCreateTime   string `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime string `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
}

// CreateGetDatasourceRequest creates a request to invoke GetDatasource API
func CreateGetDatasourceRequest() (request *GetDatasourceRequest) {
	request = &GetDatasourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "GetDatasource", "/api/v1/instances/[InstanceId]/datasources/[DatasourceId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDatasourceResponse creates a response to parse from GetDatasource response
func CreateGetDatasourceResponse() (response *GetDatasourceResponse) {
	response = &GetDatasourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
