package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExperiments invokes the pairecservice.ListExperiments API synchronously
func (client *Client) ListExperiments(request *ListExperimentsRequest) (response *ListExperimentsResponse, err error) {
	response = CreateListExperimentsResponse()
	err = client.DoAction(request, response)
	return
}

// ListExperimentsWithChan invokes the pairecservice.ListExperiments API asynchronously
func (client *Client) ListExperimentsWithChan(request *ListExperimentsRequest) (<-chan *ListExperimentsResponse, <-chan error) {
	responseChan := make(chan *ListExperimentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExperiments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExperimentsWithCallback invokes the pairecservice.ListExperiments API asynchronously
func (client *Client) ListExperimentsWithCallback(request *ListExperimentsRequest, callback func(response *ListExperimentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExperimentsResponse
		var err error
		defer close(result)
		response, err = client.ListExperiments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExperimentsRequest is the request struct for api ListExperiments
type ListExperimentsRequest struct {
	*requests.RoaRequest
	Query             string `position:"Query" name:"Query"`
	InstanceId        string `position:"Query" name:"InstanceId"`
	ExperimentGroupId string `position:"Query" name:"ExperimentGroupId"`
	Status            string `position:"Query" name:"Status"`
}

// ListExperimentsResponse is the response struct for api ListExperiments
type ListExperimentsResponse struct {
	*responses.BaseResponse
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	TotalCount  int64             `json:"TotalCount" xml:"TotalCount"`
	Experiments []ExperimentsItem `json:"Experiments" xml:"Experiments"`
}

// CreateListExperimentsRequest creates a request to invoke ListExperiments API
func CreateListExperimentsRequest() (request *ListExperimentsRequest) {
	request = &ListExperimentsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListExperiments", "/api/v1/experiments", "", "")
	request.Method = requests.GET
	return
}

// CreateListExperimentsResponse creates a response to parse from ListExperiments response
func CreateListExperimentsResponse() (response *ListExperimentsResponse) {
	response = &ListExperimentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
