package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopSampleConsistencyJob invokes the pairecservice.StopSampleConsistencyJob API synchronously
func (client *Client) StopSampleConsistencyJob(request *StopSampleConsistencyJobRequest) (response *StopSampleConsistencyJobResponse, err error) {
	response = CreateStopSampleConsistencyJobResponse()
	err = client.DoAction(request, response)
	return
}

// StopSampleConsistencyJobWithChan invokes the pairecservice.StopSampleConsistencyJob API asynchronously
func (client *Client) StopSampleConsistencyJobWithChan(request *StopSampleConsistencyJobRequest) (<-chan *StopSampleConsistencyJobResponse, <-chan error) {
	responseChan := make(chan *StopSampleConsistencyJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopSampleConsistencyJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopSampleConsistencyJobWithCallback invokes the pairecservice.StopSampleConsistencyJob API asynchronously
func (client *Client) StopSampleConsistencyJobWithCallback(request *StopSampleConsistencyJobRequest, callback func(response *StopSampleConsistencyJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopSampleConsistencyJobResponse
		var err error
		defer close(result)
		response, err = client.StopSampleConsistencyJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopSampleConsistencyJobRequest is the request struct for api StopSampleConsistencyJob
type StopSampleConsistencyJobRequest struct {
	*requests.RoaRequest
	SampleConsistencyJobId string `position:"Path" name:"SampleConsistencyJobId"`
	InstanceId             string `position:"Query" name:"InstanceId"`
}

// StopSampleConsistencyJobResponse is the response struct for api StopSampleConsistencyJob
type StopSampleConsistencyJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopSampleConsistencyJobRequest creates a request to invoke StopSampleConsistencyJob API
func CreateStopSampleConsistencyJobRequest() (request *StopSampleConsistencyJobRequest) {
	request = &StopSampleConsistencyJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "StopSampleConsistencyJob", "/api/v1/sampleconsistencyjobs/[SampleConsistencyJobId]/action/stop", "", "")
	request.Method = requests.POST
	return
}

// CreateStopSampleConsistencyJobResponse creates a response to parse from StopSampleConsistencyJob response
func CreateStopSampleConsistencyJobResponse() (response *StopSampleConsistencyJobResponse) {
	response = &StopSampleConsistencyJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
