package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopTrafficControlTarget invokes the pairecservice.StopTrafficControlTarget API synchronously
func (client *Client) StopTrafficControlTarget(request *StopTrafficControlTargetRequest) (response *StopTrafficControlTargetResponse, err error) {
	response = CreateStopTrafficControlTargetResponse()
	err = client.DoAction(request, response)
	return
}

// StopTrafficControlTargetWithChan invokes the pairecservice.StopTrafficControlTarget API asynchronously
func (client *Client) StopTrafficControlTargetWithChan(request *StopTrafficControlTargetRequest) (<-chan *StopTrafficControlTargetResponse, <-chan error) {
	responseChan := make(chan *StopTrafficControlTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopTrafficControlTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopTrafficControlTargetWithCallback invokes the pairecservice.StopTrafficControlTarget API asynchronously
func (client *Client) StopTrafficControlTargetWithCallback(request *StopTrafficControlTargetRequest, callback func(response *StopTrafficControlTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopTrafficControlTargetResponse
		var err error
		defer close(result)
		response, err = client.StopTrafficControlTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopTrafficControlTargetRequest is the request struct for api StopTrafficControlTarget
type StopTrafficControlTargetRequest struct {
	*requests.RoaRequest
	TrafficControlTargetId string `position:"Path" name:"TrafficControlTargetId"`
	Body                   string `position:"Body" name:"body"`
}

// StopTrafficControlTargetResponse is the response struct for api StopTrafficControlTarget
type StopTrafficControlTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopTrafficControlTargetRequest creates a request to invoke StopTrafficControlTarget API
func CreateStopTrafficControlTargetRequest() (request *StopTrafficControlTargetRequest) {
	request = &StopTrafficControlTargetRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "StopTrafficControlTarget", "/api/v1/trafficcontroltargets/[TrafficControlTargetId]/action/stop", "", "")
	request.Method = requests.POST
	return
}

// CreateStopTrafficControlTargetResponse creates a response to parse from StopTrafficControlTarget response
func CreateStopTrafficControlTargetResponse() (response *StopTrafficControlTargetResponse) {
	response = &StopTrafficControlTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
