package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateInstanceResource invokes the pairecservice.UpdateInstanceResource API synchronously
func (client *Client) UpdateInstanceResource(request *UpdateInstanceResourceRequest) (response *UpdateInstanceResourceResponse, err error) {
	response = CreateUpdateInstanceResourceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateInstanceResourceWithChan invokes the pairecservice.UpdateInstanceResource API asynchronously
func (client *Client) UpdateInstanceResourceWithChan(request *UpdateInstanceResourceRequest) (<-chan *UpdateInstanceResourceResponse, <-chan error) {
	responseChan := make(chan *UpdateInstanceResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateInstanceResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateInstanceResourceWithCallback invokes the pairecservice.UpdateInstanceResource API asynchronously
func (client *Client) UpdateInstanceResourceWithCallback(request *UpdateInstanceResourceRequest, callback func(response *UpdateInstanceResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateInstanceResourceResponse
		var err error
		defer close(result)
		response, err = client.UpdateInstanceResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateInstanceResourceRequest is the request struct for api UpdateInstanceResource
type UpdateInstanceResourceRequest struct {
	*requests.RoaRequest
	ResourceId string `position:"Path" name:"ResourceId"`
	InstanceId string `position:"Path" name:"InstanceId"`
	Body       string `position:"Body" name:"body"`
}

// UpdateInstanceResourceResponse is the response struct for api UpdateInstanceResource
type UpdateInstanceResourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateInstanceResourceRequest creates a request to invoke UpdateInstanceResource API
func CreateUpdateInstanceResourceRequest() (request *UpdateInstanceResourceRequest) {
	request = &UpdateInstanceResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UpdateInstanceResource", "/api/v1/instances/[InstanceId]/resources/[ResourceId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateInstanceResourceResponse creates a response to parse from UpdateInstanceResource response
func CreateUpdateInstanceResourceResponse() (response *UpdateInstanceResourceResponse) {
	response = &UpdateInstanceResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
