package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBProxyPerformance invokes the polardb.DescribeDBProxyPerformance API synchronously
func (client *Client) DescribeDBProxyPerformance(request *DescribeDBProxyPerformanceRequest) (response *DescribeDBProxyPerformanceResponse, err error) {
	response = CreateDescribeDBProxyPerformanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBProxyPerformanceWithChan invokes the polardb.DescribeDBProxyPerformance API asynchronously
func (client *Client) DescribeDBProxyPerformanceWithChan(request *DescribeDBProxyPerformanceRequest) (<-chan *DescribeDBProxyPerformanceResponse, <-chan error) {
	responseChan := make(chan *DescribeDBProxyPerformanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBProxyPerformance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBProxyPerformanceWithCallback invokes the polardb.DescribeDBProxyPerformance API asynchronously
func (client *Client) DescribeDBProxyPerformanceWithCallback(request *DescribeDBProxyPerformanceRequest, callback func(response *DescribeDBProxyPerformanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBProxyPerformanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBProxyPerformance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBProxyPerformanceRequest is the request struct for api DescribeDBProxyPerformance
type DescribeDBProxyPerformanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBNodeId             string           `position:"Query" name:"DBNodeId"`
	DBEndpointId         string           `position:"Query" name:"DBEndpointId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	Type                 string           `position:"Query" name:"Type"`
	Key                  string           `position:"Query" name:"Key"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Metric               string           `position:"Query" name:"Metric"`
	Interval             string           `position:"Query" name:"Interval"`
}

// DescribeDBProxyPerformanceResponse is the response struct for api DescribeDBProxyPerformance
type DescribeDBProxyPerformanceResponse struct {
	*responses.BaseResponse
	DBVersion       string                                      `json:"DBVersion" xml:"DBVersion"`
	EndTime         string                                      `json:"EndTime" xml:"EndTime"`
	RequestId       string                                      `json:"RequestId" xml:"RequestId"`
	StartTime       string                                      `json:"StartTime" xml:"StartTime"`
	DBClusterId     string                                      `json:"DBClusterId" xml:"DBClusterId"`
	DBType          string                                      `json:"DBType" xml:"DBType"`
	Engine          string                                      `json:"Engine" xml:"Engine"`
	PerformanceKeys PerformanceKeysInDescribeDBProxyPerformance `json:"PerformanceKeys" xml:"PerformanceKeys"`
}

// CreateDescribeDBProxyPerformanceRequest creates a request to invoke DescribeDBProxyPerformance API
func CreateDescribeDBProxyPerformanceRequest() (request *DescribeDBProxyPerformanceRequest) {
	request = &DescribeDBProxyPerformanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeDBProxyPerformance", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBProxyPerformanceResponse creates a response to parse from DescribeDBProxyPerformance response
func CreateDescribeDBProxyPerformanceResponse() (response *DescribeDBProxyPerformanceResponse) {
	response = &DescribeDBProxyPerformanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
