package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBNodesClass invokes the polardb.ModifyDBNodesClass API synchronously
func (client *Client) ModifyDBNodesClass(request *ModifyDBNodesClassRequest) (response *ModifyDBNodesClassResponse, err error) {
	response = CreateModifyDBNodesClassResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBNodesClassWithChan invokes the polardb.ModifyDBNodesClass API asynchronously
func (client *Client) ModifyDBNodesClassWithChan(request *ModifyDBNodesClassRequest) (<-chan *ModifyDBNodesClassResponse, <-chan error) {
	responseChan := make(chan *ModifyDBNodesClassResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBNodesClass(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBNodesClassWithCallback invokes the polardb.ModifyDBNodesClass API asynchronously
func (client *Client) ModifyDBNodesClassWithCallback(request *ModifyDBNodesClassRequest, callback func(response *ModifyDBNodesClassResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBNodesClassResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBNodesClass(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBNodesClassRequest is the request struct for api ModifyDBNodesClass
type ModifyDBNodesClassRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer            `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string                      `position:"Query" name:"ClientToken"`
	PlannedEndTime         string                      `position:"Query" name:"PlannedEndTime"`
	ResourceOwnerAccount   string                      `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId            string                      `position:"Query" name:"DBClusterId"`
	OwnerAccount           string                      `position:"Query" name:"OwnerAccount"`
	PlannedFlashingOffTime string                      `position:"Query" name:"PlannedFlashingOffTime"`
	OwnerId                requests.Integer            `position:"Query" name:"OwnerId"`
	PlannedStartTime       string                      `position:"Query" name:"PlannedStartTime"`
	ModifyType             string                      `position:"Query" name:"ModifyType"`
	SubCategory            string                      `position:"Query" name:"SubCategory"`
	DBNode                 *[]ModifyDBNodesClassDBNode `position:"Query" name:"DBNode"  type:"Repeated"`
}

// ModifyDBNodesClassDBNode is a repeated param struct in ModifyDBNodesClassRequest
type ModifyDBNodesClassDBNode struct {
	DBNodeId    string `name:"DBNodeId"`
	TargetClass string `name:"TargetClass"`
}

// ModifyDBNodesClassResponse is the response struct for api ModifyDBNodesClass
type ModifyDBNodesClassResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	DBClusterId string `json:"DBClusterId" xml:"DBClusterId"`
	OrderId     string `json:"OrderId" xml:"OrderId"`
}

// CreateModifyDBNodesClassRequest creates a request to invoke ModifyDBNodesClass API
func CreateModifyDBNodesClassRequest() (request *ModifyDBNodesClassRequest) {
	request = &ModifyDBNodesClassRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ModifyDBNodesClass", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBNodesClassResponse creates a response to parse from ModifyDBNodesClass response
func CreateModifyDBNodesClassResponse() (response *ModifyDBNodesClassResponse) {
	response = &ModifyDBNodesClassResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
