package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBNodePerformance invokes the polardbx.DescribeDBNodePerformance API synchronously
func (client *Client) DescribeDBNodePerformance(request *DescribeDBNodePerformanceRequest) (response *DescribeDBNodePerformanceResponse, err error) {
	response = CreateDescribeDBNodePerformanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBNodePerformanceWithChan invokes the polardbx.DescribeDBNodePerformance API asynchronously
func (client *Client) DescribeDBNodePerformanceWithChan(request *DescribeDBNodePerformanceRequest) (<-chan *DescribeDBNodePerformanceResponse, <-chan error) {
	responseChan := make(chan *DescribeDBNodePerformanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBNodePerformance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBNodePerformanceWithCallback invokes the polardbx.DescribeDBNodePerformance API asynchronously
func (client *Client) DescribeDBNodePerformanceWithCallback(request *DescribeDBNodePerformanceRequest, callback func(response *DescribeDBNodePerformanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBNodePerformanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBNodePerformance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBNodePerformanceRequest is the request struct for api DescribeDBNodePerformance
type DescribeDBNodePerformanceRequest struct {
	*requests.RpcRequest
	StartTime      string `position:"Query" name:"StartTime"`
	DBNodeRole     string `position:"Query" name:"DBNodeRole"`
	CharacterType  string `position:"Query" name:"CharacterType"`
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
	DBNodeIds      string `position:"Query" name:"DBNodeIds"`
	Key            string `position:"Query" name:"Key"`
	EndTime        string `position:"Query" name:"EndTime"`
}

// DescribeDBNodePerformanceResponse is the response struct for api DescribeDBNodePerformance
type DescribeDBNodePerformanceResponse struct {
	*responses.BaseResponse
	EndTime         string          `json:"EndTime" xml:"EndTime"`
	StartTime       string          `json:"StartTime" xml:"StartTime"`
	DBInstanceName  string          `json:"DBInstanceName" xml:"DBInstanceName"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	Engine          string          `json:"Engine" xml:"Engine"`
	PerformanceKeys PerformanceKeys `json:"PerformanceKeys" xml:"PerformanceKeys"`
}

// CreateDescribeDBNodePerformanceRequest creates a request to invoke DescribeDBNodePerformance API
func CreateDescribeDBNodePerformanceRequest() (request *DescribeDBNodePerformanceRequest) {
	request = &DescribeDBNodePerformanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeDBNodePerformance", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBNodePerformanceResponse creates a response to parse from DescribeDBNodePerformance response
func CreateDescribeDBNodePerformanceResponse() (response *DescribeDBNodePerformanceResponse) {
	response = &DescribeDBNodePerformanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
