package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveEnv invokes the pts.SaveEnv API synchronously
func (client *Client) SaveEnv(request *SaveEnvRequest) (response *SaveEnvResponse, err error) {
	response = CreateSaveEnvResponse()
	err = client.DoAction(request, response)
	return
}

// SaveEnvWithChan invokes the pts.SaveEnv API asynchronously
func (client *Client) SaveEnvWithChan(request *SaveEnvRequest) (<-chan *SaveEnvResponse, <-chan error) {
	responseChan := make(chan *SaveEnvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveEnv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveEnvWithCallback invokes the pts.SaveEnv API asynchronously
func (client *Client) SaveEnvWithCallback(request *SaveEnvRequest, callback func(response *SaveEnvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveEnvResponse
		var err error
		defer close(result)
		response, err = client.SaveEnv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveEnvRequest is the request struct for api SaveEnv
type SaveEnvRequest struct {
	*requests.RpcRequest
	Env SaveEnvEnv `position:"Query" name:"Env"  type:"Struct"`
}

// SaveEnvEnv is a repeated param struct in SaveEnvRequest
type SaveEnvEnv struct {
	EnvName           string                      `name:"EnvName"`
	Files             *[]SaveEnvEnvFilesItem      `name:"Files" type:"Repeated"`
	JmeterPluginLabel string                      `name:"JmeterPluginLabel"`
	EnvId             string                      `name:"EnvId"`
	Properties        *[]SaveEnvEnvPropertiesItem `name:"Properties" type:"Repeated"`
}

// SaveEnvEnvFilesItem is a repeated param struct in SaveEnvRequest
type SaveEnvEnvFilesItem struct {
	FileName       string `name:"FileName"`
	FileOssAddress string `name:"FileOssAddress"`
}

// SaveEnvEnvPropertiesItem is a repeated param struct in SaveEnvRequest
type SaveEnvEnvPropertiesItem struct {
	Name        string `name:"Name"`
	Description string `name:"Description"`
	Value       string `name:"Value"`
}

// SaveEnvResponse is the response struct for api SaveEnv
type SaveEnvResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	EnvId          string `json:"EnvId" xml:"EnvId"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateSaveEnvRequest creates a request to invoke SaveEnv API
func CreateSaveEnvRequest() (request *SaveEnvRequest) {
	request = &SaveEnvRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "SaveEnv", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveEnvResponse creates a response to parse from SaveEnv response
func CreateSaveEnvResponse() (response *SaveEnvResponse) {
	response = &SaveEnvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
