package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartDebuggingJMeterScene invokes the pts.StartDebuggingJMeterScene API synchronously
func (client *Client) StartDebuggingJMeterScene(request *StartDebuggingJMeterSceneRequest) (response *StartDebuggingJMeterSceneResponse, err error) {
	response = CreateStartDebuggingJMeterSceneResponse()
	err = client.DoAction(request, response)
	return
}

// StartDebuggingJMeterSceneWithChan invokes the pts.StartDebuggingJMeterScene API asynchronously
func (client *Client) StartDebuggingJMeterSceneWithChan(request *StartDebuggingJMeterSceneRequest) (<-chan *StartDebuggingJMeterSceneResponse, <-chan error) {
	responseChan := make(chan *StartDebuggingJMeterSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartDebuggingJMeterScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartDebuggingJMeterSceneWithCallback invokes the pts.StartDebuggingJMeterScene API asynchronously
func (client *Client) StartDebuggingJMeterSceneWithCallback(request *StartDebuggingJMeterSceneRequest, callback func(response *StartDebuggingJMeterSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartDebuggingJMeterSceneResponse
		var err error
		defer close(result)
		response, err = client.StartDebuggingJMeterScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartDebuggingJMeterSceneRequest is the request struct for api StartDebuggingJMeterScene
type StartDebuggingJMeterSceneRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
}

// StartDebuggingJMeterSceneResponse is the response struct for api StartDebuggingJMeterScene
type StartDebuggingJMeterSceneResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Message        string `json:"Message" xml:"Message"`
	ReportId       string `json:"ReportId" xml:"ReportId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateStartDebuggingJMeterSceneRequest creates a request to invoke StartDebuggingJMeterScene API
func CreateStartDebuggingJMeterSceneRequest() (request *StartDebuggingJMeterSceneRequest) {
	request = &StartDebuggingJMeterSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "StartDebuggingJMeterScene", "", "")
	request.Method = requests.POST
	return
}

// CreateStartDebuggingJMeterSceneResponse creates a response to parse from StartDebuggingJMeterScene response
func CreateStartDebuggingJMeterSceneResponse() (response *StartDebuggingJMeterSceneResponse) {
	response = &StartDebuggingJMeterSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
