package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBusinessSpaces invokes the qualitycheck.ListBusinessSpaces API synchronously
func (client *Client) ListBusinessSpaces(request *ListBusinessSpacesRequest) (response *ListBusinessSpacesResponse, err error) {
	response = CreateListBusinessSpacesResponse()
	err = client.DoAction(request, response)
	return
}

// ListBusinessSpacesWithChan invokes the qualitycheck.ListBusinessSpaces API asynchronously
func (client *Client) ListBusinessSpacesWithChan(request *ListBusinessSpacesRequest) (<-chan *ListBusinessSpacesResponse, <-chan error) {
	responseChan := make(chan *ListBusinessSpacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBusinessSpaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBusinessSpacesWithCallback invokes the qualitycheck.ListBusinessSpaces API asynchronously
func (client *Client) ListBusinessSpacesWithCallback(request *ListBusinessSpacesRequest, callback func(response *ListBusinessSpacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBusinessSpacesResponse
		var err error
		defer close(result)
		response, err = client.ListBusinessSpaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBusinessSpacesRequest is the request struct for api ListBusinessSpaces
type ListBusinessSpacesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// ListBusinessSpacesResponse is the response struct for api ListBusinessSpaces
type ListBusinessSpacesResponse struct {
	*responses.BaseResponse
	CurrentPage int        `json:"CurrentPage" xml:"CurrentPage"`
	PageSize    int        `json:"PageSize" xml:"PageSize"`
	PageNumber  int        `json:"PageNumber" xml:"PageNumber"`
	RequestId   string     `json:"RequestId" xml:"RequestId"`
	Success     bool       `json:"Success" xml:"Success"`
	Code        string     `json:"Code" xml:"Code"`
	Message     string     `json:"Message" xml:"Message"`
	Data        []DataItem `json:"Data" xml:"Data"`
}

// CreateListBusinessSpacesRequest creates a request to invoke ListBusinessSpaces API
func CreateListBusinessSpacesRequest() (request *ListBusinessSpacesRequest) {
	request = &ListBusinessSpacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ListBusinessSpaces", "", "")
	request.Method = requests.POST
	return
}

// CreateListBusinessSpacesResponse creates a response to parse from ListBusinessSpaces response
func CreateListBusinessSpacesResponse() (response *ListBusinessSpacesResponse) {
	response = &ListBusinessSpacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
