package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSessionGroup invokes the qualitycheck.ListSessionGroup API synchronously
func (client *Client) ListSessionGroup(request *ListSessionGroupRequest) (response *ListSessionGroupResponse, err error) {
	response = CreateListSessionGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListSessionGroupWithChan invokes the qualitycheck.ListSessionGroup API asynchronously
func (client *Client) ListSessionGroupWithChan(request *ListSessionGroupRequest) (<-chan *ListSessionGroupResponse, <-chan error) {
	responseChan := make(chan *ListSessionGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSessionGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSessionGroupWithCallback invokes the qualitycheck.ListSessionGroup API asynchronously
func (client *Client) ListSessionGroupWithCallback(request *ListSessionGroupRequest, callback func(response *ListSessionGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSessionGroupResponse
		var err error
		defer close(result)
		response, err = client.ListSessionGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSessionGroupRequest is the request struct for api ListSessionGroup
type ListSessionGroupRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// ListSessionGroupResponse is the response struct for api ListSessionGroup
type ListSessionGroupResponse struct {
	*responses.BaseResponse
	Count          int                        `json:"Count" xml:"Count"`
	CurrentPage    int                        `json:"CurrentPage" xml:"CurrentPage"`
	PageSize       int                        `json:"PageSize" xml:"PageSize"`
	PageNumber     int                        `json:"PageNumber" xml:"PageNumber"`
	ResultCountId  string                     `json:"ResultCountId" xml:"ResultCountId"`
	LastDataId     string                     `json:"LastDataId" xml:"LastDataId"`
	RequestId      string                     `json:"RequestId" xml:"RequestId"`
	Success        bool                       `json:"Success" xml:"Success"`
	Code           string                     `json:"Code" xml:"Code"`
	Message        string                     `json:"Message" xml:"Message"`
	HttpStatusCode int                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInListSessionGroup `json:"Messages" xml:"Messages"`
	Data           DataInListSessionGroup     `json:"Data" xml:"Data"`
}

// CreateListSessionGroupRequest creates a request to invoke ListSessionGroup API
func CreateListSessionGroupRequest() (request *ListSessionGroupRequest) {
	request = &ListSessionGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ListSessionGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateListSessionGroupResponse creates a response to parse from ListSessionGroup response
func CreateListSessionGroupResponse() (response *ListSessionGroupResponse) {
	response = &ListSessionGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
