package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSchemeTaskConfig invokes the qualitycheck.UpdateSchemeTaskConfig API synchronously
func (client *Client) UpdateSchemeTaskConfig(request *UpdateSchemeTaskConfigRequest) (response *UpdateSchemeTaskConfigResponse, err error) {
	response = CreateUpdateSchemeTaskConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSchemeTaskConfigWithChan invokes the qualitycheck.UpdateSchemeTaskConfig API asynchronously
func (client *Client) UpdateSchemeTaskConfigWithChan(request *UpdateSchemeTaskConfigRequest) (<-chan *UpdateSchemeTaskConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateSchemeTaskConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSchemeTaskConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSchemeTaskConfigWithCallback invokes the qualitycheck.UpdateSchemeTaskConfig API asynchronously
func (client *Client) UpdateSchemeTaskConfigWithCallback(request *UpdateSchemeTaskConfigRequest, callback func(response *UpdateSchemeTaskConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSchemeTaskConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateSchemeTaskConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSchemeTaskConfigRequest is the request struct for api UpdateSchemeTaskConfig
type UpdateSchemeTaskConfigRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// UpdateSchemeTaskConfigResponse is the response struct for api UpdateSchemeTaskConfig
type UpdateSchemeTaskConfigResponse struct {
	*responses.BaseResponse
	RequestId      string                           `json:"RequestId" xml:"RequestId"`
	Success        bool                             `json:"Success" xml:"Success"`
	Code           string                           `json:"Code" xml:"Code"`
	Message        string                           `json:"Message" xml:"Message"`
	HttpStatusCode int                              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInUpdateSchemeTaskConfig `json:"Messages" xml:"Messages"`
}

// CreateUpdateSchemeTaskConfigRequest creates a request to invoke UpdateSchemeTaskConfig API
func CreateUpdateSchemeTaskConfigRequest() (request *UpdateSchemeTaskConfigRequest) {
	request = &UpdateSchemeTaskConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateSchemeTaskConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateSchemeTaskConfigResponse creates a response to parse from UpdateSchemeTaskConfig response
func CreateUpdateSchemeTaskConfigResponse() (response *UpdateSchemeTaskConfigResponse) {
	response = &UpdateSchemeTaskConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
