package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListWorkspaceRoles invokes the quickbi_public.ListWorkspaceRoles API synchronously
func (client *Client) ListWorkspaceRoles(request *ListWorkspaceRolesRequest) (response *ListWorkspaceRolesResponse, err error) {
	response = CreateListWorkspaceRolesResponse()
	err = client.DoAction(request, response)
	return
}

// ListWorkspaceRolesWithChan invokes the quickbi_public.ListWorkspaceRoles API asynchronously
func (client *Client) ListWorkspaceRolesWithChan(request *ListWorkspaceRolesRequest) (<-chan *ListWorkspaceRolesResponse, <-chan error) {
	responseChan := make(chan *ListWorkspaceRolesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListWorkspaceRoles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListWorkspaceRolesWithCallback invokes the quickbi_public.ListWorkspaceRoles API asynchronously
func (client *Client) ListWorkspaceRolesWithCallback(request *ListWorkspaceRolesRequest, callback func(response *ListWorkspaceRolesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListWorkspaceRolesResponse
		var err error
		defer close(result)
		response, err = client.ListWorkspaceRoles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListWorkspaceRolesRequest is the request struct for api ListWorkspaceRoles
type ListWorkspaceRolesRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// ListWorkspaceRolesResponse is the response struct for api ListWorkspaceRoles
type ListWorkspaceRolesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    []Data `json:"Result" xml:"Result"`
}

// CreateListWorkspaceRolesRequest creates a request to invoke ListWorkspaceRoles API
func CreateListWorkspaceRolesRequest() (request *ListWorkspaceRolesRequest) {
	request = &ListWorkspaceRolesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "ListWorkspaceRoles", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListWorkspaceRolesResponse creates a response to parse from ListWorkspaceRoles response
func CreateListWorkspaceRolesResponse() (response *ListWorkspaceRolesResponse) {
	response = &ListWorkspaceRolesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
