package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySmartqPermissionByCubeId invokes the quickbi_public.QuerySmartqPermissionByCubeId API synchronously
func (client *Client) QuerySmartqPermissionByCubeId(request *QuerySmartqPermissionByCubeIdRequest) (response *QuerySmartqPermissionByCubeIdResponse, err error) {
	response = CreateQuerySmartqPermissionByCubeIdResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySmartqPermissionByCubeIdWithChan invokes the quickbi_public.QuerySmartqPermissionByCubeId API asynchronously
func (client *Client) QuerySmartqPermissionByCubeIdWithChan(request *QuerySmartqPermissionByCubeIdRequest) (<-chan *QuerySmartqPermissionByCubeIdResponse, <-chan error) {
	responseChan := make(chan *QuerySmartqPermissionByCubeIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySmartqPermissionByCubeId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySmartqPermissionByCubeIdWithCallback invokes the quickbi_public.QuerySmartqPermissionByCubeId API asynchronously
func (client *Client) QuerySmartqPermissionByCubeIdWithCallback(request *QuerySmartqPermissionByCubeIdRequest, callback func(response *QuerySmartqPermissionByCubeIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySmartqPermissionByCubeIdResponse
		var err error
		defer close(result)
		response, err = client.QuerySmartqPermissionByCubeId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySmartqPermissionByCubeIdRequest is the request struct for api QuerySmartqPermissionByCubeId
type QuerySmartqPermissionByCubeIdRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	UserId      string `position:"Query" name:"UserId"`
	CubeId      string `position:"Query" name:"CubeId"`
	SignType    string `position:"Query" name:"SignType"`
}

// QuerySmartqPermissionByCubeIdResponse is the response struct for api QuerySmartqPermissionByCubeId
type QuerySmartqPermissionByCubeIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateQuerySmartqPermissionByCubeIdRequest creates a request to invoke QuerySmartqPermissionByCubeId API
func CreateQuerySmartqPermissionByCubeIdRequest() (request *QuerySmartqPermissionByCubeIdRequest) {
	request = &QuerySmartqPermissionByCubeIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QuerySmartqPermissionByCubeId", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySmartqPermissionByCubeIdResponse creates a response to parse from QuerySmartqPermissionByCubeId response
func CreateQuerySmartqPermissionByCubeIdResponse() (response *QuerySmartqPermissionByCubeIdResponse) {
	response = &QuerySmartqPermissionByCubeIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
