package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTairKVCacheCustomInstances invokes the r_kvstore.DescribeTairKVCacheCustomInstances API synchronously
func (client *Client) DescribeTairKVCacheCustomInstances(request *DescribeTairKVCacheCustomInstancesRequest) (response *DescribeTairKVCacheCustomInstancesResponse, err error) {
	response = CreateDescribeTairKVCacheCustomInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTairKVCacheCustomInstancesWithChan invokes the r_kvstore.DescribeTairKVCacheCustomInstances API asynchronously
func (client *Client) DescribeTairKVCacheCustomInstancesWithChan(request *DescribeTairKVCacheCustomInstancesRequest) (<-chan *DescribeTairKVCacheCustomInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeTairKVCacheCustomInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTairKVCacheCustomInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTairKVCacheCustomInstancesWithCallback invokes the r_kvstore.DescribeTairKVCacheCustomInstances API asynchronously
func (client *Client) DescribeTairKVCacheCustomInstancesWithCallback(request *DescribeTairKVCacheCustomInstancesRequest, callback func(response *DescribeTairKVCacheCustomInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTairKVCacheCustomInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeTairKVCacheCustomInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTairKVCacheCustomInstancesRequest is the request struct for api DescribeTairKVCacheCustomInstances
type DescribeTairKVCacheCustomInstancesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                         `position:"Query" name:"ResourceOwnerId"`
	SearchKey            string                                   `position:"Query" name:"SearchKey"`
	NetworkType          string                                   `position:"Query" name:"NetworkType"`
	InstanceClass        string                                   `position:"Query" name:"InstanceClass"`
	PageNumber           requests.Integer                         `position:"Query" name:"PageNumber"`
	ResourceGroupId      string                                   `position:"Query" name:"ResourceGroupId"`
	Expired              string                                   `position:"Query" name:"Expired"`
	SecurityToken        string                                   `position:"Query" name:"SecurityToken"`
	PageSize             requests.Integer                         `position:"Query" name:"PageSize"`
	InstanceType         string                                   `position:"Query" name:"InstanceType"`
	Tag                  *[]DescribeTairKVCacheCustomInstancesTag `position:"Query" name:"Tag"  type:"Repeated"`
	InstanceStatus       string                                   `position:"Query" name:"InstanceStatus"`
	ResourceOwnerAccount string                                   `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                                   `position:"Query" name:"OwnerAccount"`
	PrivateIp            string                                   `position:"Query" name:"PrivateIp"`
	OwnerId              requests.Integer                         `position:"Query" name:"OwnerId"`
	VSwitchId            string                                   `position:"Query" name:"VSwitchId"`
	InstanceIds          string                                   `position:"Query" name:"InstanceIds"`
	VpcId                string                                   `position:"Query" name:"VpcId"`
	ZoneId               string                                   `position:"Query" name:"ZoneId"`
	ChargeType           string                                   `position:"Query" name:"ChargeType"`
}

// DescribeTairKVCacheCustomInstancesTag is a repeated param struct in DescribeTairKVCacheCustomInstancesRequest
type DescribeTairKVCacheCustomInstancesTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeTairKVCacheCustomInstancesResponse is the response struct for api DescribeTairKVCacheCustomInstances
type DescribeTairKVCacheCustomInstancesResponse struct {
	*responses.BaseResponse
	RequestId  string                                        `json:"RequestId" xml:"RequestId"`
	PageNumber int                                           `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                                           `json:"PageSize" xml:"PageSize"`
	TotalCount int                                           `json:"TotalCount" xml:"TotalCount"`
	Instances  InstancesInDescribeTairKVCacheCustomInstances `json:"Instances" xml:"Instances"`
}

// CreateDescribeTairKVCacheCustomInstancesRequest creates a request to invoke DescribeTairKVCacheCustomInstances API
func CreateDescribeTairKVCacheCustomInstancesRequest() (request *DescribeTairKVCacheCustomInstancesRequest) {
	request = &DescribeTairKVCacheCustomInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeTairKVCacheCustomInstances", "redisa", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeTairKVCacheCustomInstancesResponse creates a response to parse from DescribeTairKVCacheCustomInstances response
func CreateDescribeTairKVCacheCustomInstancesResponse() (response *DescribeTairKVCacheCustomInstancesResponse) {
	response = &DescribeTairKVCacheCustomInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
