package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDBInstanceEndpointAddress invokes the rds.CreateDBInstanceEndpointAddress API synchronously
func (client *Client) CreateDBInstanceEndpointAddress(request *CreateDBInstanceEndpointAddressRequest) (response *CreateDBInstanceEndpointAddressResponse, err error) {
	response = CreateCreateDBInstanceEndpointAddressResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDBInstanceEndpointAddressWithChan invokes the rds.CreateDBInstanceEndpointAddress API asynchronously
func (client *Client) CreateDBInstanceEndpointAddressWithChan(request *CreateDBInstanceEndpointAddressRequest) (<-chan *CreateDBInstanceEndpointAddressResponse, <-chan error) {
	responseChan := make(chan *CreateDBInstanceEndpointAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDBInstanceEndpointAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDBInstanceEndpointAddressWithCallback invokes the rds.CreateDBInstanceEndpointAddress API asynchronously
func (client *Client) CreateDBInstanceEndpointAddressWithCallback(request *CreateDBInstanceEndpointAddressRequest, callback func(response *CreateDBInstanceEndpointAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDBInstanceEndpointAddressResponse
		var err error
		defer close(result)
		response, err = client.CreateDBInstanceEndpointAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDBInstanceEndpointAddressRequest is the request struct for api CreateDBInstanceEndpointAddress
type CreateDBInstanceEndpointAddressRequest struct {
	*requests.RpcRequest
	ConnectionStringPrefix string           `position:"Query" name:"ConnectionStringPrefix"`
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string           `position:"Query" name:"ClientToken"`
	ResourceGroupId        string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId           string           `position:"Query" name:"DBInstanceId"`
	IpType                 string           `position:"Query" name:"IpType"`
	DBInstanceEndpointId   string           `position:"Query" name:"DBInstanceEndpointId"`
	Port                   string           `position:"Query" name:"Port"`
}

// CreateDBInstanceEndpointAddressResponse is the response struct for api CreateDBInstanceEndpointAddress
type CreateDBInstanceEndpointAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateDBInstanceEndpointAddressRequest creates a request to invoke CreateDBInstanceEndpointAddress API
func CreateCreateDBInstanceEndpointAddressRequest() (request *CreateDBInstanceEndpointAddressRequest) {
	request = &CreateDBInstanceEndpointAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateDBInstanceEndpointAddress", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDBInstanceEndpointAddressResponse creates a response to parse from CreateDBInstanceEndpointAddress response
func CreateCreateDBInstanceEndpointAddressResponse() (response *CreateDBInstanceEndpointAddressResponse) {
	response = &CreateDBInstanceEndpointAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
