package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHistoryTasks invokes the rds.DescribeHistoryTasks API synchronously
func (client *Client) DescribeHistoryTasks(request *DescribeHistoryTasksRequest) (response *DescribeHistoryTasksResponse, err error) {
	response = CreateDescribeHistoryTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHistoryTasksWithChan invokes the rds.DescribeHistoryTasks API asynchronously
func (client *Client) DescribeHistoryTasksWithChan(request *DescribeHistoryTasksRequest) (<-chan *DescribeHistoryTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeHistoryTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHistoryTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHistoryTasksWithCallback invokes the rds.DescribeHistoryTasks API asynchronously
func (client *Client) DescribeHistoryTasksWithCallback(request *DescribeHistoryTasksRequest, callback func(response *DescribeHistoryTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHistoryTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeHistoryTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHistoryTasksRequest is the request struct for api DescribeHistoryTasks
type DescribeHistoryTasksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ToStartTime          string           `position:"Query" name:"ToStartTime"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ToExecTime           requests.Integer `position:"Query" name:"ToExecTime"`
	TaskType             string           `position:"Query" name:"TaskType"`
	ResourceOwnerAccount requests.Integer `position:"Query" name:"ResourceOwnerAccount"`
	FromStartTime        string           `position:"Query" name:"FromStartTime"`
	FromExecTime         requests.Integer `position:"Query" name:"FromExecTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Status               string           `position:"Query" name:"Status"`
}

// DescribeHistoryTasksResponse is the response struct for api DescribeHistoryTasks
type DescribeHistoryTasksResponse struct {
	*responses.BaseResponse
	PageNumber int                               `json:"PageNumber" xml:"PageNumber"`
	RequestId  string                            `json:"RequestId" xml:"RequestId"`
	PageSize   int                               `json:"PageSize" xml:"PageSize"`
	TotalCount int                               `json:"TotalCount" xml:"TotalCount"`
	Items      []ItemsItemInDescribeHistoryTasks `json:"Items" xml:"Items"`
}

// CreateDescribeHistoryTasksRequest creates a request to invoke DescribeHistoryTasks API
func CreateDescribeHistoryTasksRequest() (request *DescribeHistoryTasksRequest) {
	request = &DescribeHistoryTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeHistoryTasks", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHistoryTasksResponse creates a response to parse from DescribeHistoryTasks response
func CreateDescribeHistoryTasksResponse() (response *DescribeHistoryTasksResponse) {
	response = &DescribeHistoryTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
