package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePostgresExtensions invokes the rds.DescribePostgresExtensions API synchronously
func (client *Client) DescribePostgresExtensions(request *DescribePostgresExtensionsRequest) (response *DescribePostgresExtensionsResponse, err error) {
	response = CreateDescribePostgresExtensionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePostgresExtensionsWithChan invokes the rds.DescribePostgresExtensions API asynchronously
func (client *Client) DescribePostgresExtensionsWithChan(request *DescribePostgresExtensionsRequest) (<-chan *DescribePostgresExtensionsResponse, <-chan error) {
	responseChan := make(chan *DescribePostgresExtensionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePostgresExtensions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePostgresExtensionsWithCallback invokes the rds.DescribePostgresExtensions API asynchronously
func (client *Client) DescribePostgresExtensionsWithCallback(request *DescribePostgresExtensionsRequest, callback func(response *DescribePostgresExtensionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePostgresExtensionsResponse
		var err error
		defer close(result)
		response, err = client.DescribePostgresExtensions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePostgresExtensionsRequest is the request struct for api DescribePostgresExtensions
type DescribePostgresExtensionsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBName               string           `position:"Query" name:"DBName"`
}

// DescribePostgresExtensionsResponse is the response struct for api DescribePostgresExtensions
type DescribePostgresExtensionsResponse struct {
	*responses.BaseResponse
	RequestId             string                 `json:"RequestId" xml:"RequestId"`
	Overview              map[string]interface{} `json:"Overview" xml:"Overview"`
	UninstalledExtensions []Extension            `json:"UninstalledExtensions" xml:"UninstalledExtensions"`
	InstalledExtensions   []Extension            `json:"InstalledExtensions" xml:"InstalledExtensions"`
}

// CreateDescribePostgresExtensionsRequest creates a request to invoke DescribePostgresExtensions API
func CreateDescribePostgresExtensionsRequest() (request *DescribePostgresExtensionsRequest) {
	request = &DescribePostgresExtensionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribePostgresExtensions", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePostgresExtensionsResponse creates a response to parse from DescribePostgresExtensions response
func CreateDescribePostgresExtensionsResponse() (response *DescribePostgresExtensionsResponse) {
	response = &DescribePostgresExtensionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
