package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWhitelistTemplate invokes the rds.ModifyWhitelistTemplate API synchronously
func (client *Client) ModifyWhitelistTemplate(request *ModifyWhitelistTemplateRequest) (response *ModifyWhitelistTemplateResponse, err error) {
	response = CreateModifyWhitelistTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWhitelistTemplateWithChan invokes the rds.ModifyWhitelistTemplate API asynchronously
func (client *Client) ModifyWhitelistTemplateWithChan(request *ModifyWhitelistTemplateRequest) (<-chan *ModifyWhitelistTemplateResponse, <-chan error) {
	responseChan := make(chan *ModifyWhitelistTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWhitelistTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWhitelistTemplateWithCallback invokes the rds.ModifyWhitelistTemplate API asynchronously
func (client *Client) ModifyWhitelistTemplateWithCallback(request *ModifyWhitelistTemplateRequest, callback func(response *ModifyWhitelistTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWhitelistTemplateResponse
		var err error
		defer close(result)
		response, err = client.ModifyWhitelistTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWhitelistTemplateRequest is the request struct for api ModifyWhitelistTemplate
type ModifyWhitelistTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	TemplateId           requests.Integer `position:"Query" name:"TemplateId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	TemplateName         string           `position:"Query" name:"TemplateName"`
	IpWhitelist          string           `position:"Query" name:"IpWhitelist"`
}

// ModifyWhitelistTemplateResponse is the response struct for api ModifyWhitelistTemplate
type ModifyWhitelistTemplateResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateModifyWhitelistTemplateRequest creates a request to invoke ModifyWhitelistTemplate API
func CreateModifyWhitelistTemplateRequest() (request *ModifyWhitelistTemplateRequest) {
	request = &ModifyWhitelistTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyWhitelistTemplate", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyWhitelistTemplateResponse creates a response to parse from ModifyWhitelistTemplate response
func CreateModifyWhitelistTemplateResponse() (response *ModifyWhitelistTemplateResponse) {
	response = &ModifyWhitelistTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
