package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceShareInvitations invokes the resourcesharing.ListResourceShareInvitations API synchronously
func (client *Client) ListResourceShareInvitations(request *ListResourceShareInvitationsRequest) (response *ListResourceShareInvitationsResponse, err error) {
	response = CreateListResourceShareInvitationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceShareInvitationsWithChan invokes the resourcesharing.ListResourceShareInvitations API asynchronously
func (client *Client) ListResourceShareInvitationsWithChan(request *ListResourceShareInvitationsRequest) (<-chan *ListResourceShareInvitationsResponse, <-chan error) {
	responseChan := make(chan *ListResourceShareInvitationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceShareInvitations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceShareInvitationsWithCallback invokes the resourcesharing.ListResourceShareInvitations API asynchronously
func (client *Client) ListResourceShareInvitationsWithCallback(request *ListResourceShareInvitationsRequest, callback func(response *ListResourceShareInvitationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceShareInvitationsResponse
		var err error
		defer close(result)
		response, err = client.ListResourceShareInvitations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceShareInvitationsRequest is the request struct for api ListResourceShareInvitations
type ListResourceShareInvitationsRequest struct {
	*requests.RpcRequest
	ResourceShareInvitationIds *[]string        `position:"Query" name:"ResourceShareInvitationIds"  type:"Repeated"`
	NextToken                  string           `position:"Query" name:"NextToken"`
	ResourceShareIds           *[]string        `position:"Query" name:"ResourceShareIds"  type:"Repeated"`
	MaxResults                 requests.Integer `position:"Query" name:"MaxResults"`
}

// ListResourceShareInvitationsResponse is the response struct for api ListResourceShareInvitations
type ListResourceShareInvitationsResponse struct {
	*responses.BaseResponse
	NextToken                string                    `json:"NextToken" xml:"NextToken"`
	RequestId                string                    `json:"RequestId" xml:"RequestId"`
	ResourceShareInvitations []ResourceShareInvitation `json:"ResourceShareInvitations" xml:"ResourceShareInvitations"`
}

// CreateListResourceShareInvitationsRequest creates a request to invoke ListResourceShareInvitations API
func CreateListResourceShareInvitationsRequest() (request *ListResourceShareInvitationsRequest) {
	request = &ListResourceShareInvitationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "ListResourceShareInvitations", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListResourceShareInvitationsResponse creates a response to parse from ListResourceShareInvitations response
func CreateListResourceShareInvitationsResponse() (response *ListResourceShareInvitationsResponse) {
	response = &ListResourceShareInvitationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
