package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartInstances invokes the sae.RestartInstances API synchronously
func (client *Client) RestartInstances(request *RestartInstancesRequest) (response *RestartInstancesResponse, err error) {
	response = CreateRestartInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// RestartInstancesWithChan invokes the sae.RestartInstances API asynchronously
func (client *Client) RestartInstancesWithChan(request *RestartInstancesRequest) (<-chan *RestartInstancesResponse, <-chan error) {
	responseChan := make(chan *RestartInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartInstancesWithCallback invokes the sae.RestartInstances API asynchronously
func (client *Client) RestartInstancesWithCallback(request *RestartInstancesRequest, callback func(response *RestartInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartInstancesResponse
		var err error
		defer close(result)
		response, err = client.RestartInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartInstancesRequest is the request struct for api RestartInstances
type RestartInstancesRequest struct {
	*requests.RoaRequest
	InstanceIds string `position:"Query" name:"InstanceIds"`
	AppId       string `position:"Query" name:"AppId"`
}

// RestartInstancesResponse is the response struct for api RestartInstances
type RestartInstancesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRestartInstancesRequest creates a request to invoke RestartInstances API
func CreateRestartInstancesRequest() (request *RestartInstancesRequest) {
	request = &RestartInstancesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "RestartInstances", "/pop/v1/sam/app/restartInstances", "serverless", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateRestartInstancesResponse creates a response to parse from RestartInstances response
func CreateRestartInstancesResponse() (response *RestartInstancesResponse) {
	response = &RestartInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
