package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SafeChangeCheck invokes the safe.SafeChangeCheck API synchronously
func (client *Client) SafeChangeCheck(request *SafeChangeCheckRequest) (response *SafeChangeCheckResponse, err error) {
	response = CreateSafeChangeCheckResponse()
	err = client.DoAction(request, response)
	return
}

// SafeChangeCheckWithChan invokes the safe.SafeChangeCheck API asynchronously
func (client *Client) SafeChangeCheckWithChan(request *SafeChangeCheckRequest) (<-chan *SafeChangeCheckResponse, <-chan error) {
	responseChan := make(chan *SafeChangeCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SafeChangeCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SafeChangeCheckWithCallback invokes the safe.SafeChangeCheck API asynchronously
func (client *Client) SafeChangeCheckWithCallback(request *SafeChangeCheckRequest, callback func(response *SafeChangeCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SafeChangeCheckResponse
		var err error
		defer close(result)
		response, err = client.SafeChangeCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SafeChangeCheckRequest is the request struct for api SafeChangeCheck
type SafeChangeCheckRequest struct {
	*requests.RpcRequest
	ChangeEnv                string                                  `position:"Body" name:"ChangeEnv"`
	ChangeOptSubType         string                                  `position:"Body" name:"ChangeOptSubType"`
	AuthKey                  string                                  `position:"Body" name:"AuthKey"`
	ReleasePackageInfos      *[]SafeChangeCheckReleasePackageInfos   `position:"Body" name:"ReleasePackageInfos"  type:"Repeated"`
	Instance                 SafeChangeCheckInstance                 `position:"Body" name:"Instance"  type:"Struct"`
	ChangeOptType            string                                  `position:"Body" name:"ChangeOptType"`
	ChangeDataType           string                                  `position:"Body" name:"ChangeDataType"`
	AuthSign                 string                                  `position:"Body" name:"AuthSign"`
	DamagedChangeNotices     *[]SafeChangeCheckDamagedChangeNotices  `position:"Body" name:"DamagedChangeNotices"  type:"Repeated"`
	InfluenceInfo            SafeChangeCheckInfluenceInfo            `position:"Body" name:"InfluenceInfo"  type:"Struct"`
	Checker                  *[]string                               `position:"Query" name:"Checker"  type:"Repeated"`
	OperateEmpNo             string                                  `position:"Body" name:"OperateEmpNo"`
	ExtraInfo                string                                  `position:"Body" name:"ExtraInfo"`
	ChangeSchemes            string                                  `position:"Body" name:"ChangeSchemes"`
	WhiteType                requests.Integer                        `position:"Body" name:"whiteType"`
	ChangeTimes              *[]SafeChangeCheckChangeTimes           `position:"Body" name:"ChangeTimes"  type:"Repeated"`
	ChangeValidation         string                                  `position:"Body" name:"ChangeValidation"`
	ReuseSourceOrderId       string                                  `position:"Body" name:"ReuseSourceOrderId"`
	ChangeEndTime            requests.Integer                        `position:"Body" name:"ChangeEndTime"`
	SourceOrderId            string                                  `position:"Body" name:"SourceOrderId"`
	CallBackInfo             SafeChangeCheckCallBackInfo             `position:"Body" name:"CallBackInfo"  type:"Struct"`
	Rollback                 string                                  `position:"Body" name:"Rollback"`
	BlockInfos               *[]SafeChangeCheckBlockInfos            `position:"Body" name:"BlockInfos"  type:"Repeated"`
	GrayStatus               string                                  `position:"Body" name:"GrayStatus"`
	Product                  *[]SafeChangeCheckProduct               `position:"Body" name:"Product"  type:"Repeated"`
	BgCustomTemplateExtraDTO SafeChangeCheckBgCustomTemplateExtraDTO `position:"Body" name:"BgCustomTemplateExtraDTO"  type:"Struct"`
	Follower                 *[]string                               `position:"Body" name:"Follower"  type:"Repeated"`
	ChangeObject             string                                  `position:"Body" name:"ChangeObject"`
	SourceName               string                                  `position:"Body" name:"SourceName"`
	RiskLevel                string                                  `position:"Body" name:"RiskLevel"`
	ChangeTitle              string                                  `position:"Body" name:"ChangeTitle"`
	NeedModifyDoc            string                                  `position:"Body" name:"NeedModifyDoc"`
	CreatorEmpId             string                                  `position:"Body" name:"CreatorEmpId"`
	ChangeStartTime          requests.Integer                        `position:"Body" name:"ChangeStartTime"`
	SourceUrl                string                                  `position:"Body" name:"SourceUrl"`
	ReqTimestamp             requests.Integer                        `position:"Body" name:"ReqTimestamp"`
	HarmChangeNoticeEnum     string                                  `position:"Query" name:"HarmChangeNoticeEnum"`
	ChangeDesc               string                                  `position:"Body" name:"ChangeDesc"`
	ExecutorEmpId            string                                  `position:"Body" name:"ExecutorEmpId"`
	AffectCustomer           string                                  `position:"Body" name:"AffectCustomer"`
	ChangeSubTypeDesc        string                                  `position:"Body" name:"ChangeSubTypeDesc"`
	ChangeSystem             string                                  `position:"Body" name:"ChangeSystem"`
	Incidence                string                                  `position:"Body" name:"Incidence"`
	ApproveFlowParam         SafeChangeCheckApproveFlowParam         `position:"Body" name:"ApproveFlowParam"  type:"Struct"`
	ChangeReason             string                                  `position:"Body" name:"ChangeReason"`
	ChangeRmarks             string                                  `position:"Body" name:"ChangeRmarks"`
	ChangeItems              string                                  `position:"Body" name:"ChangeItems"`
}

// SafeChangeCheckDamagedChangeNotices is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckDamagedChangeNotices struct {
	EventId               string                                                       `name:"EventId"`
	BgCancelNoticeContent string                                                       `name:"BgCancelNoticeContent"`
	Channel               *[]string                                                    `name:"Channel" type:"Repeated"`
	Type                  string                                                       `name:"Type"`
	BgCancelNoticeEventId string                                                       `name:"BgCancelNoticeEventId"`
	Content               string                                                       `name:"Content"`
	SensitiveCustomers    *[]SafeChangeCheckDamagedChangeNoticesSensitiveCustomersItem `name:"SensitiveCustomers" type:"Repeated"`
}

// SafeChangeCheckDamagedChangeNoticesSensitiveCustomersItem is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckDamagedChangeNoticesSensitiveCustomersItem struct {
	ProductCode  string                                                                       `name:"ProductCode"`
	CustomerInfo *[]SafeChangeCheckDamagedChangeNoticesSensitiveCustomersItemCustomerInfoItem `name:"CustomerInfo" type:"Repeated"`
}

// SafeChangeCheckDamagedChangeNoticesSensitiveCustomersItemCustomerInfoItem is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckDamagedChangeNoticesSensitiveCustomersItemCustomerInfoItem struct {
	Uid       string            `name:"Uid"`
	Type      string            `name:"Type"`
	ExtraInfo map[string]string `name:"ExtraInfo" type:"Map"`
}

// SafeChangeCheckReleasePackageInfos is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckReleasePackageInfos struct {
	ReleasePackage *[]string `name:"ReleasePackage" type:"Repeated"`
	ProductCode    string    `name:"ProductCode"`
}

// SafeChangeCheckInstance is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckInstance struct {
	Instance       *[]string `name:"instance" type:"Repeated"`
	Nc             *[]string `name:"Nc" type:"Repeated"`
	Uids           *[]string `name:"Uids" type:"Repeated"`
	InfluenceApp   *[]string `name:"influenceApp" type:"Repeated"`
	AttributionApp *[]string `name:"attributionApp" type:"Repeated"`
}

// SafeChangeCheckInfluenceInfo is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckInfluenceInfo struct {
	NoticeInfos        *[]SafeChangeCheckInfluenceInfoNoticeInfosItem        `name:"NoticeInfos" type:"Repeated"`
	SensitiveCustomers *[]SafeChangeCheckInfluenceInfoSensitiveCustomersItem `name:"SensitiveCustomers" type:"Repeated"`
}

// SafeChangeCheckChangeTimes is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckChangeTimes struct {
	ChangeEndTime   string `name:"ChangeEndTime"`
	ChangeStartTime string `name:"ChangeStartTime"`
}

// SafeChangeCheckCallBackInfo is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckCallBackInfo struct {
	PopProduct string `name:"PopProduct"`
	EndPoint   string `name:"EndPoint"`
	RegionId   string `name:"RegionId"`
	ApiVersion string `name:"ApiVersion"`
	Api        string `name:"Api"`
	Type       string `name:"Type"`
	Url        string `name:"Url"`
}

// SafeChangeCheckBlockInfos is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckBlockInfos struct {
	HitInfos *[]SafeChangeCheckBlockInfosHitInfos `name:"HitInfos" type:"Repeated"`
	Id       string                               `name:"Id"`
}

// SafeChangeCheckProduct is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckProduct struct {
	Code string `name:"Code"`
	Name string `name:"Name"`
}

// SafeChangeCheckBgCustomTemplateExtraDTO is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckBgCustomTemplateExtraDTO struct {
	BgCustomTemplateInfo string `name:"BgCustomTemplateInfo"`
}

// SafeChangeCheckApproveFlowParam is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckApproveFlowParam struct {
	ApproveNodes *[]SafeChangeCheckApproveFlowParamApproveNodesItem `name:"ApproveNodes" type:"Repeated"`
	FlowStatus   string                                             `name:"FlowStatus"`
}

// SafeChangeCheckInfluenceInfoNoticeInfosItem is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckInfluenceInfoNoticeInfosItem struct {
	EventId string    `name:"EventId"`
	Channel *[]string `name:"Channel" type:"Repeated"`
	Content string    `name:"Content"`
}

// SafeChangeCheckInfluenceInfoSensitiveCustomersItem is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckInfluenceInfoSensitiveCustomersItem struct {
	ProductCode  string                                                                `name:"ProductCode"`
	CustomerInfo *[]SafeChangeCheckInfluenceInfoSensitiveCustomersItemCustomerInfoItem `name:"CustomerInfo" type:"Repeated"`
}

// SafeChangeCheckBlockInfosHitInfos is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckBlockInfosHitInfos struct {
	Scope     string `name:"Scope"`
	HitObject string `name:"HitObject"`
	HitInfo   string `name:"HitInfo"`
}

// SafeChangeCheckApproveFlowParamApproveNodesItem is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckApproveFlowParamApproveNodesItem struct {
	ProcessName      string                                                            `name:"ProcessName"`
	NodeStatus       string                                                            `name:"NodeStatus"`
	ApproverDTO      *[]SafeChangeCheckApproveFlowParamApproveNodesItemApproverDTOItem `name:"ApproverDTO" type:"Repeated"`
	Strategy         string                                                            `name:"Strategy"`
	ProcessNodeOrder string                                                            `name:"ProcessNodeOrder"`
}

// SafeChangeCheckInfluenceInfoSensitiveCustomersItemCustomerInfoItem is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckInfluenceInfoSensitiveCustomersItemCustomerInfoItem struct {
	Uid       string            `name:"Uid"`
	Type      string            `name:"Type"`
	ExtraInfo map[string]string `name:"ExtraInfo" type:"Map"`
}

// SafeChangeCheckApproveFlowParamApproveNodesItemApproverDTOItem is a repeated param struct in SafeChangeCheckRequest
type SafeChangeCheckApproveFlowParamApproveNodesItemApproverDTOItem struct {
	ApproveDesc  string `name:"ApproveDesc"`
	ApproverId   string `name:"ApproverId"`
	ApproverName string `name:"ApproverName"`
	ApproveTime  string `name:"ApproveTime"`
	Opinion      string `name:"Opinion"`
}

// SafeChangeCheckResponse is the response struct for api SafeChangeCheck
type SafeChangeCheckResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSafeChangeCheckRequest creates a request to invoke SafeChangeCheck API
func CreateSafeChangeCheckRequest() (request *SafeChangeCheckRequest) {
	request = &SafeChangeCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "SafeChangeCheck", "", "")
	request.Method = requests.POST
	return
}

// CreateSafeChangeCheckResponse creates a response to parse from SafeChangeCheck response
func CreateSafeChangeCheckResponse() (response *SafeChangeCheckResponse) {
	response = &SafeChangeCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
